/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols;

import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.symbols.AnnotWrapper;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValueHelper;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassNamesUtil;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.OptionalBool;
import org.apache.commons.lang3.AnnotationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

public interface SymbolicValue {
    public boolean valueEquals(Object var1);

    public boolean equals(Object var1);

    public static @Nullable SymbolicValue of(TypeSystem ts, Object value) {
        Objects.requireNonNull(ts);
        if (value == null) {
            return null;
        }
        if (SymValue.isOkValue(value)) {
            return new SymValue(value);
        }
        if (value instanceof Enum) {
            return SymEnum.fromEnum(ts, (Enum)value);
        }
        if (value instanceof Annotation) {
            return AnnotWrapper.wrap(ts, (Annotation)value);
        }
        if (value instanceof Class) {
            return SymClass.ofBinaryName(ts, ((Class)value).getName());
        }
        if (value.getClass().isArray()) {
            if (!SymArray.isOkComponentType(value.getClass().getComponentType())) {
                return null;
            }
            return SymArray.forArray(ts, value);
        }
        return null;
    }

    public static final class SymClass
    implements SymbolicValue {
        private final String binaryName;

        private SymClass(String binaryName) {
            this.binaryName = binaryName;
        }

        public static SymClass ofBinaryName(TypeSystem ts, String binaryName) {
            return new SymClass(binaryName);
        }

        @Override
        public boolean valueEquals(Object o) {
            return o instanceof Class && ((Class)o).getName().equals(this.binaryName);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SymClass symClass = (SymClass)o;
            return Objects.equals(this.binaryName, symClass.binaryName);
        }

        public int hashCode() {
            return this.binaryName.hashCode();
        }
    }

    public static final class SymValue
    implements SymbolicValue {
        private final Object value;

        private SymValue(Object value) {
            assert (value != null && SymValue.isOkValue(value)) : "Invalid value " + value;
            this.value = value;
        }

        private static boolean isOkValue(@NonNull Object value) {
            return ClassUtils.isPrimitiveWrapper(value.getClass()) || value instanceof String;
        }

        @Override
        public boolean valueEquals(Object o) {
            return Objects.equals(this.value, o);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SymValue symValue = (SymValue)o;
            return this.valueEquals(symValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static final class SymEnum
    implements SymbolicValue {
        private final String enumBinaryName;
        private final String enumName;

        private SymEnum(String enumBinaryName, String enumConstName) {
            this.enumBinaryName = Objects.requireNonNull(enumBinaryName);
            this.enumName = Objects.requireNonNull(enumConstName);
        }

        public <E extends Enum<E>> @Nullable E toEnum(Class<E> enumClass) {
            return (E)(enumClass.getName().equals(this.enumBinaryName) ? EnumUtils.getEnum(enumClass, (String)this.enumName) : null);
        }

        public static SymbolicValue fromEnum(TypeSystem ts, Enum<?> value) {
            return SymEnum.fromBinaryName(ts, value.getDeclaringClass().getName(), value.name());
        }

        public static SymEnum fromBinaryName(TypeSystem ts, String enumBinaryName, String enumConstName) {
            return new SymEnum(enumBinaryName, enumConstName);
        }

        public static SymEnum fromTypeDescriptor(TypeSystem ts, String enumTypeDescriptor, String enumConstName) {
            String enumBinaryName = ClassNamesUtil.classDescriptorToBinaryName(enumTypeDescriptor);
            return SymEnum.fromBinaryName(ts, enumBinaryName, enumConstName);
        }

        @Override
        public boolean valueEquals(Object o) {
            if (!(o instanceof Enum)) {
                return false;
            }
            Enum value = (Enum)o;
            return this.enumName.equals(value.name()) && this.enumBinaryName.equals(value.getDeclaringClass().getName());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SymEnum that = (SymEnum)o;
            return Objects.equals(this.enumBinaryName, that.enumBinaryName) && Objects.equals(this.enumName, that.enumName);
        }

        public int hashCode() {
            return Objects.hash(this.enumBinaryName, this.enumName);
        }

        public String toString() {
            return this.enumBinaryName + "#" + this.enumName;
        }
    }

    public static final class SymArray
    implements SymbolicValue {
        private final @Nullable List<SymbolicValue> elements;
        private final @Nullable Object primArray;
        private final int length;

        private SymArray(@Nullable List<SymbolicValue> elements, @Nullable Object primArray, int length) {
            this.elements = elements;
            this.primArray = primArray;
            this.length = length;
            assert (elements == null ^ primArray == null) : "Either elements or array must be mentioned";
            assert (primArray == null || primArray.getClass().isArray());
        }

        public static SymArray forElements(List<SymbolicValue> values) {
            return new SymArray(Collections.unmodifiableList(new ArrayList<SymbolicValue>(values)), null, values.size());
        }

        static SymArray forArray(TypeSystem ts, @NonNull Object array) {
            if (!array.getClass().isArray()) {
                throw new IllegalArgumentException("Needs an array, got " + array);
            }
            if (array.getClass().getComponentType().isPrimitive()) {
                int len = Array.getLength(array);
                return new SymArray(null, array, len);
            }
            Object[] arr = (Object[])array;
            if (!SymArray.isOkComponentType(arr.getClass().getComponentType())) {
                throw new IllegalArgumentException("Unsupported component type" + arr.getClass().getComponentType());
            }
            ArrayList<SymbolicValue> lst = new ArrayList<SymbolicValue>(arr.length);
            for (Object o : arr) {
                SymbolicValue elt = SymbolicValue.of(ts, o);
                if (elt == null) {
                    throw new IllegalArgumentException("Unsupported array element" + o);
                }
                lst.add(elt);
            }
            return new SymArray(lst, null, arr.length);
        }

        static boolean isOkComponentType(Class<?> compType) {
            return compType.isPrimitive() || compType == String.class || compType == Class.class || compType.isEnum() || compType.isAnnotation();
        }

        public int length() {
            return this.length;
        }

        public boolean containsValue(Object value) {
            if (this.primArray != null) {
                throw new NotImplementedException("not implemented: containsValue with a primitive array");
            }
            if (this.elements != null) {
                return this.elements.stream().anyMatch(it -> SymbolicValueHelper.equalsModuloWrapper(it, value));
            }
            return false;
        }

        @Override
        public boolean valueEquals(Object o) {
            if (!o.getClass().isArray() || !SymArray.isOkComponentType(o.getClass().getComponentType())) {
                return false;
            }
            if (this.primArray != null) {
                return Objects.deepEquals(this.primArray, o);
            }
            if (!(o instanceof Object[])) {
                return false;
            }
            assert (this.elements != null);
            Object[] arr = (Object[])o;
            if (arr.length != this.length) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (this.elements.get(i).valueEquals(arr[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SymArray array = (SymArray)o;
            if (this.elements != null) {
                return Objects.equals(this.elements, array.elements);
            }
            return Objects.deepEquals(this.primArray, array.primArray);
        }

        public int hashCode() {
            if (this.elements != null) {
                return this.elements.hashCode();
            }
            assert (this.primArray != null);
            return this.primArray.hashCode();
        }

        public String toString() {
            if (this.elements != null) {
                return "[list " + this.elements + ']';
            }
            return "[array " + ArrayUtils.toString((Object)this.primArray) + ']';
        }
    }

    public static interface SymAnnot
    extends SymbolicValue {
        public @Nullable SymbolicValue getAttribute(String var1);

        public @NonNull JClassSymbol getAnnotationSymbol();

        default public PSet<String> getAttributeNames() {
            return this.getAnnotationSymbol().getAnnotationAttributeNames();
        }

        default public String getBinaryName() {
            return this.getAnnotationSymbol().getBinaryName();
        }

        default public String getSimpleName() {
            return this.getAnnotationSymbol().getSimpleName();
        }

        @Override
        default public boolean valueEquals(Object o) {
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation annot = (Annotation)o;
            if (!this.isOfType(annot.annotationType())) {
                return false;
            }
            for (String attrName : this.getAttributeNames()) {
                SymbolicValue myAttr;
                Object attr = null;
                try {
                    attr = MethodUtils.invokeExactMethod((Object)annot, (String)attrName);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
                if (attr == null || !AnnotationUtils.isValidAnnotationMemberType(attr.getClass()) || (myAttr = this.getAttribute(attrName)) != null && myAttr.valueEquals(attr)) continue;
                return false;
            }
            return true;
        }

        default public RetentionPolicy getRetention() {
            return this.getAnnotationSymbol().getAnnotationRetention();
        }

        default public boolean isOfType(String binaryName) {
            return this.getBinaryName().equals(binaryName);
        }

        default public boolean isOfType(Class<? extends Annotation> klass) {
            return this.isOfType(klass.getName());
        }

        default public OptionalBool attributeMatches(String attrName, Object attrValue) {
            SymbolicValue attr = this.getAttribute(attrName);
            if (attr == null) {
                return OptionalBool.UNKNOWN;
            }
            return OptionalBool.definitely((boolean)SymbolicValueHelper.equalsModuloWrapper(attr, attrValue));
        }

        default public OptionalBool attributeContains(String attrName, Object attrValue) {
            SymbolicValue attr = this.getAttribute(attrName);
            if (attr == null) {
                return OptionalBool.UNKNOWN;
            }
            if (attr instanceof SymArray) {
                return OptionalBool.definitely((boolean)((SymArray)attr).containsValue(attrValue));
            }
            return OptionalBool.definitely((boolean)SymbolicValueHelper.equalsModuloWrapper(attr, attrValue));
        }
    }
}

