/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConsecutiveAppendsShouldReuseRule
extends AbstractJavaRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTExpressionStatement.class, (Class[])new Class[]{ASTLocalVariableDeclaration.class});
    }

    @Override
    public Object visit(ASTExpressionStatement node, Object data) {
        JVariableSymbol nextVariable;
        JVariableSymbol variable;
        Node nextSibling = node.asStream().followingSiblings().first();
        if (nextSibling instanceof ASTExpressionStatement && (variable = this.getVariableAppended(node)) != null && (nextVariable = this.getVariableAppended((ASTExpressionStatement)nextSibling)) != null && nextVariable.equals(variable)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTVariableDeclaratorId varDecl;
        JVariableSymbol nextVariable;
        Node nextSibling = node.asStream().followingSiblings().first();
        if (nextSibling instanceof ASTExpressionStatement && (nextVariable = this.getVariableAppended((ASTExpressionStatement)nextSibling)) != null && (varDecl = (ASTVariableDeclaratorId)nextVariable.tryGetNode()) != null && node.getVarIds().any(it -> it == varDecl) && this.isStringBuilderAppend(varDecl.getInitializer())) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private @Nullable JVariableSymbol getVariableAppended(ASTExpressionStatement node) {
        ASTExpression expr = node.getExpr();
        if (expr instanceof ASTMethodCall) {
            return this.getAsVarAccess(this.getAppendChainQualifier(expr));
        }
        if (expr instanceof ASTAssignmentExpression) {
            ASTExpression rhs = ((ASTAssignmentExpression)expr).getRightOperand();
            return this.getAppendChainQualifier(rhs) != null ? this.getAssignmentLhsAsVar(expr) : null;
        }
        return null;
    }

    private @Nullable ASTExpression getAppendChainQualifier(ASTExpression base) {
        ASTExpression expr = base;
        while (expr instanceof ASTMethodCall && this.isStringBuilderAppend(expr)) {
            expr = ((ASTMethodCall)expr).getQualifier();
        }
        return base == expr ? null : expr;
    }

    private @Nullable JVariableSymbol getAssignmentLhsAsVar(@Nullable ASTExpression expr) {
        if (expr instanceof ASTAssignmentExpression) {
            return this.getAsVarAccess(((ASTAssignmentExpression)expr).getLeftOperand());
        }
        return null;
    }

    private @Nullable JVariableSymbol getAsVarAccess(@Nullable ASTExpression expr) {
        if (expr instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            return ((ASTAssignableExpr.ASTNamedReferenceExpr)expr).getReferencedSym();
        }
        return null;
    }

    private boolean isStringBuilderAppend(@Nullable ASTExpression e) {
        if (e instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)e;
            return "append".equals(call.getMethodName()) && this.isStringBuilderAppend(call.getOverloadSelectionInfo());
        }
        return false;
    }

    private boolean isStringBuilderAppend(OverloadSelectionResult result) {
        if (result.isFailed()) {
            return false;
        }
        JExecutableSymbol symbol = result.getMethodType().getSymbol();
        return TypeTestUtil.isExactlyA(StringBuffer.class, symbol.getEnclosingClass()) || TypeTestUtil.isExactlyA(StringBuilder.class, symbol.getEnclosingClass());
    }
}

