/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CommentSizeRule
extends AbstractJavaRulechainRule {
    public static final PropertyDescriptor<Integer> MAX_LINES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxLines").desc("Maximum lines")).require(NumericConstraints.positive())).defaultValue((Object)6)).build();
    public static final PropertyDescriptor<Integer> MAX_LINE_LENGTH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxLineLength").desc("Maximum line length")).require(NumericConstraints.positive())).defaultValue((Object)80)).build();

    public CommentSizeRule() {
        super(ASTCompilationUnit.class, new Class[0]);
        this.definePropertyDescriptor(MAX_LINES);
        this.definePropertyDescriptor(MAX_LINE_LENGTH);
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        for (JavaComment comment : cUnit.getComments()) {
            if (this.hasTooManyLines(comment)) {
                this.addViolationWithMessage(data, (Node)cUnit, this.getMessage() + ": Too many lines", comment.getBeginLine(), comment.getEndLine());
            }
            this.reportLinesTooLong(cUnit, this.asCtx(data), comment);
        }
        return null;
    }

    private static boolean hasRealText(Chars line) {
        return !JavaComment.removeCommentMarkup(line).isEmpty();
    }

    private boolean hasTooManyLines(JavaComment comment) {
        int firstLineWithText = -1;
        int lineNumberWithinComment = 0;
        int maxLines = (Integer)this.getProperty(MAX_LINES);
        for (Chars line : comment.getText().lines()) {
            if (CommentSizeRule.hasRealText(line)) {
                int lastLineWithText = lineNumberWithinComment;
                if (firstLineWithText == -1) {
                    firstLineWithText = lineNumberWithinComment;
                }
                if (lastLineWithText - firstLineWithText + 1 > maxLines) {
                    return true;
                }
            }
            ++lineNumberWithinComment;
        }
        return false;
    }

    private void reportLinesTooLong(ASTCompilationUnit acu, RuleContext ctx, JavaComment comment) {
        int maxLength = (Integer)this.getProperty(MAX_LINE_LENGTH);
        int lineNumber = comment.getReportLocation().getStartLine();
        for (Chars line : comment.getFilteredLines(true)) {
            if (line.length() > maxLength) {
                ctx.addViolationWithPosition((Node)acu, lineNumber, lineNumber, this.getMessage() + ": Line too long", new Object[0]);
            }
            ++lineNumber;
        }
    }
}

