/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.rule.internal.CommonPropertyDescriptors;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class SwitchDensityRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> REPORT_LEVEL = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)CommonPropertyDescriptors.reportLevelProperty().desc("Threshold above which a switch statement or expression is reported")).require(NumericConstraints.positive())).defaultValue((Object)10)).build();

    public SwitchDensityRule() {
        super(ASTSwitchStatement.class, ASTSwitchExpression.class);
        this.definePropertyDescriptor(REPORT_LEVEL);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        return this.visitSwitchLike(node, data);
    }

    @Override
    public Object visit(ASTSwitchExpression node, Object data) {
        return this.visitSwitchLike(node, data);
    }

    public Void visitSwitchLike(ASTSwitchLike node, Object data) {
        int labelCount;
        int stmtCount = node.descendants(ASTStatement.class).count();
        double density = (double)stmtCount / (double)(labelCount = node.getBranches().map(ASTSwitchBranch::getLabel).sumBy(label -> label.isDefault() ? 1 : label.getExprList().count()));
        if (density >= (double)((Integer)this.getProperty(REPORT_LEVEL)).intValue()) {
            this.addViolation(data, (Node)node);
        }
        return null;
    }
}

