/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class LoosePackageCouplingRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<List<String>> PACKAGES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"packages").desc("Restricted packages")).emptyDefaultValue().build();
    private static final PropertyDescriptor<List<String>> CLASSES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"classes").desc("Allowed classes")).emptyDefaultValue().build();
    private String thisPackage;
    private List<String> restrictedPackages;

    public LoosePackageCouplingRule() {
        this.definePropertyDescriptor(PACKAGES_DESCRIPTOR);
        this.definePropertyDescriptor(CLASSES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.restrictedPackages = new ArrayList<String>((Collection)super.getProperty(PACKAGES_DESCRIPTOR));
        this.restrictedPackages.sort(Collections.reverseOrder());
        this.thisPackage = node.getPackageName();
        node.children(ASTImportDeclaration.class).forEach(it -> ((AbstractJavaNode)it).acceptVisitor(this, data));
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        String importPackage = node.getPackageName();
        for (String pkg : this.getRestrictedPackages()) {
            if (!this.isContainingPackage(pkg, importPackage)) continue;
            if (pkg.equals(this.thisPackage) || this.isContainingPackage(pkg, this.thisPackage)) break;
            if (node.isImportOnDemand()) {
                this.addViolation(data, (Node)node, new Object[]{node.getImportedName(), pkg});
                break;
            }
            if (this.isAllowedClass(node)) continue;
            this.addViolation(data, (Node)node, new Object[]{node.getImportedName(), pkg});
            break;
        }
        return data;
    }

    protected List<String> getRestrictedPackages() {
        return this.restrictedPackages;
    }

    protected boolean isContainingPackage(String pkg1, String pkg2) {
        return pkg1.equals(pkg2) || pkg1.length() < pkg2.length() && pkg2.startsWith(pkg1) && pkg2.charAt(pkg1.length()) == '.';
    }

    protected boolean isAllowedClass(ASTImportDeclaration node) {
        String importedName = node.getImportedName();
        for (String clazz : (List)this.getProperty(CLASSES_DESCRIPTOR)) {
            if (!importedName.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean checksNothing() {
        return ((List)this.getProperty(PACKAGES_DESCRIPTOR)).isEmpty() && ((List)this.getProperty(CLASSES_DESCRIPTOR)).isEmpty();
    }

    public String dysfunctionReason() {
        return this.checksNothing() ? "No packages or classes specified" : null;
    }
}

