/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CouplingBetweenObjectsRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Integer> THRESHOLD_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"threshold").desc("Unique type reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)20)).build();
    private int couplingCount;
    private boolean inInterface;
    private final Set<JTypeMirror> typesFoundSoFar = new HashSet<JTypeMirror>();

    public CouplingBetweenObjectsRule() {
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit cu, Object data) {
        super.visit(cu, data);
        if (this.couplingCount > (Integer)this.getProperty(THRESHOLD_DESCRIPTOR)) {
            this.addViolation(data, (Node)cu, "A value of " + this.couplingCount + " may denote a high amount of coupling within the class");
        }
        this.couplingCount = 0;
        this.typesFoundSoFar.clear();
        return null;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        boolean prev = this.inInterface;
        this.inInterface = node.isInterface();
        super.visit(node, data);
        this.inInterface = prev;
        return null;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTType type = node.getResultTypeNode();
        this.checkVariableType(type);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTType type = node.getTypeNode();
        this.checkVariableType(type);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFormalParameter node, Object data) {
        ASTType type = node.getTypeNode();
        this.checkVariableType(type);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        ASTType type = node.getTypeNode();
        this.checkVariableType(type);
        return super.visit(node, data);
    }

    private void checkVariableType(ASTType typeNode) {
        if (this.inInterface || typeNode == null) {
            return;
        }
        JTypeMirror t = typeNode.getTypeMirror();
        if (!this.ignoreType(typeNode, t) && this.typesFoundSoFar.add(t)) {
            ++this.couplingCount;
        }
    }

    private boolean ignoreType(ASTType typeNode, JTypeMirror t) {
        if (typeNode.getEnclosingType() != null && typeNode.getEnclosingType().getSymbol().equals(t.getSymbol())) {
            return true;
        }
        JTypeDeclSymbol symbol = t.getSymbol();
        return symbol == null || "java.lang".equals(symbol.getPackageName()) || t.isPrimitive() || t.isBoxedPrimitive();
    }
}

