/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.CollectionUtil;

public class FieldNamingConventionsRule
extends AbstractNamingConventionRule<ASTVariableDeclaratorId> {
    private static final PropertyDescriptor<List<String>> EXCLUDED_NAMES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"exclusions").desc("Names of fields to whitelist.")).defaultValues((Object)"serialVersionUID", (Object[])new String[]{"serialPersistentFields"}).build();
    private static final Set<String> MAKE_FIELD_STATIC_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.experimental.UtilityClass", (Object[])new String[0]);
    private final PropertyDescriptor<Pattern> publicConstantFieldRegex = this.defaultProp("public constant").defaultValue("[A-Z][A-Z_0-9]*").build();
    private final PropertyDescriptor<Pattern> constantFieldRegex = ((PropertyBuilder.RegexPropertyBuilder)this.defaultProp("constant").desc("Regex which applies to non-public static final field names")).defaultValue("[A-Z][A-Z_0-9]*").build();
    private final PropertyDescriptor<Pattern> enumConstantRegex = this.defaultProp("enum constant").defaultValue("[A-Z][A-Z_0-9]*").build();
    private final PropertyDescriptor<Pattern> finalFieldRegex = this.defaultProp("final field").build();
    private final PropertyDescriptor<Pattern> staticFieldRegex = this.defaultProp("static field").build();
    private final PropertyDescriptor<Pattern> defaultFieldRegex = this.defaultProp("defaultField", "field").build();

    public FieldNamingConventionsRule() {
        super(ASTFieldDeclaration.class, ASTEnumConstant.class);
        this.definePropertyDescriptor(this.publicConstantFieldRegex);
        this.definePropertyDescriptor(this.constantFieldRegex);
        this.definePropertyDescriptor(this.enumConstantRegex);
        this.definePropertyDescriptor(this.finalFieldRegex);
        this.definePropertyDescriptor(this.staticFieldRegex);
        this.definePropertyDescriptor(this.defaultFieldRegex);
        this.definePropertyDescriptor(EXCLUDED_NAMES);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        for (ASTVariableDeclaratorId id : node) {
            boolean isStatic;
            if (((List)this.getProperty(EXCLUDED_NAMES)).contains(id.getVariableName())) continue;
            ASTAnyTypeDeclaration enclosingType = node.getEnclosingType();
            boolean isFinal = node.hasModifiers(JModifier.FINAL, new JModifier[0]);
            boolean bl = isStatic = node.hasModifiers(JModifier.STATIC, new JModifier[0]) || JavaAstUtils.hasAnyAnnotation(enclosingType, MAKE_FIELD_STATIC_CLASS_ANNOT);
            if (isFinal && isStatic) {
                this.checkMatches(id, node.getVisibility() == AccessNode.Visibility.V_PUBLIC ? this.publicConstantFieldRegex : this.constantFieldRegex, data);
                continue;
            }
            if (isFinal) {
                this.checkMatches(id, this.finalFieldRegex, data);
                continue;
            }
            if (isStatic) {
                this.checkMatches(id, this.staticFieldRegex, data);
                continue;
            }
            this.checkMatches(id, this.defaultFieldRegex, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumConstant node, Object data) {
        if (!((Pattern)this.getProperty(this.enumConstantRegex)).matcher(node.getImage()).matches()) {
            this.addViolation(data, (Node)node, new Object[]{"enum constant", node.getImage(), ((Pattern)this.getProperty(this.enumConstantRegex)).toString()});
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String nameExtractor(ASTVariableDeclaratorId node) {
        return node.getName();
    }

    @Override
    String kindDisplayName(ASTVariableDeclaratorId node, PropertyDescriptor<Pattern> descriptor) {
        boolean isFinal = node.hasModifiers(JModifier.FINAL, new JModifier[0]);
        boolean isStatic = node.hasModifiers(JModifier.STATIC, new JModifier[0]);
        if (isFinal && isStatic) {
            return node.getVisibility() == AccessNode.Visibility.V_PUBLIC ? "public constant" : "constant";
        }
        if (isFinal) {
            return "final field";
        }
        if (isStatic) {
            return "static field";
        }
        return "field";
    }
}

