/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.lang.reflect.Modifier;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimExpr;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTArrayTypeDim;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;

public class MethodReturnsInternalArrayRule
extends AbstractJavaRulechainRule {
    public MethodReturnsInternalArrayRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        if (!method.getResultTypeNode().getTypeMirror().isArray() || method.getVisibility() == AccessNode.Visibility.V_PRIVATE) {
            return data;
        }
        for (ASTReturnStatement returnStmt : method.descendants(ASTReturnStatement.class)) {
            JFieldSymbol field;
            ASTExpression expr = returnStmt.getExpr();
            if (!(expr instanceof ASTAssignableExpr.ASTNamedReferenceExpr)) continue;
            ASTAssignableExpr.ASTNamedReferenceExpr reference = (ASTAssignableExpr.ASTNamedReferenceExpr)expr;
            if (JavaAstUtils.isRefToFieldOfThisInstance(reference)) {
                this.addViolation(data, (Node)returnStmt, reference.getName());
                continue;
            }
            JVariableSymbol symbol = reference.getReferencedSym();
            if (!(symbol instanceof JFieldSymbol) || !(field = (JFieldSymbol)symbol).isStatic() || !MethodReturnsInternalArrayRule.isInternal(field) || MethodReturnsInternalArrayRule.isZeroLengthArrayConstant(field)) continue;
            this.addViolation(data, (Node)returnStmt, reference.getName());
        }
        return data;
    }

    private static boolean isInternal(JFieldSymbol field) {
        return !Modifier.isPublic(field.getModifiers()) && !field.isUnresolved();
    }

    private static boolean isZeroLengthArrayConstant(JFieldSymbol sym) {
        return sym.isFinal() && NodeStream.of((Node)((ASTVariableDeclaratorId)sym.tryGetNode())).map(ASTVariableDeclaratorId::getInitializer).filter(MethodReturnsInternalArrayRule::isZeroLengthArrayExpr).nonEmpty();
    }

    private static boolean isZeroLengthArrayExpr(ASTExpression expr) {
        if (expr instanceof ASTArrayInitializer) {
            return ((ASTArrayInitializer)expr).length() == 0;
        }
        if (expr instanceof ASTArrayAllocation) {
            ASTArrayInitializer init = ((ASTArrayAllocation)expr).getArrayInitializer();
            if (init != null) {
                return init.length() == 0;
            }
            ASTArrayTypeDim lastChild = (ASTArrayTypeDim)((ASTArrayAllocation)expr).getTypeNode().getDimensions().getLastChild();
            if (lastChild instanceof ASTArrayDimExpr) {
                return JavaAstUtils.isLiteralInt(((ASTArrayDimExpr)lastChild).getLengthExpression(), 0);
            }
        }
        return false;
    }
}

