/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collection;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import org.apache.commons.lang3.StringUtils;

public interface Annotatable
extends JavaNode {
    default public NodeStream<ASTAnnotation> getDeclaredAnnotations() {
        return this.children(ASTAnnotation.class);
    }

    default public boolean isAnnotationPresent(String annotQualifiedName) {
        return this.getDeclaredAnnotations().any(t -> TypeTestUtil.isA(StringUtils.deleteWhitespace((String)annotQualifiedName), (TypeNode)t));
    }

    default public boolean isAnnotationPresent(Class<?> type) {
        return this.getDeclaredAnnotations().any(t -> TypeTestUtil.isA(type, (TypeNode)t));
    }

    default public ASTAnnotation getAnnotation(String binaryName) {
        return (ASTAnnotation)this.getDeclaredAnnotations().filter(t -> TypeTestUtil.isA(StringUtils.deleteWhitespace((String)binaryName), (TypeNode)t)).first();
    }

    default public boolean isAnyAnnotationPresent(Collection<String> binaryNames) {
        for (String annotQualifiedName : binaryNames) {
            if (!this.isAnnotationPresent(annotQualifiedName)) continue;
            return true;
        }
        return false;
    }
}

