/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Iterator;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;

public interface ASTSwitchLike
extends JavaNode,
Iterable<ASTSwitchBranch> {
    default public boolean hasDefaultCase() {
        return this.getBranches().any(it -> it.getLabel().isDefault());
    }

    default public NodeStream<ASTSwitchBranch> getBranches() {
        return this.children(ASTSwitchBranch.class);
    }

    default public ASTExpression getTestedExpression() {
        return (ASTExpression)this.getChild(0);
    }

    default public boolean isExhaustiveEnumSwitch() {
        JTypeDeclSymbol symbol = this.getTestedExpression().getTypeMirror().getSymbol();
        if (symbol instanceof JClassSymbol && ((JClassSymbol)symbol).isEnum()) {
            long numConstants = ((JClassSymbol)symbol).getEnumConstants().size();
            int numLabels = this.getBranches().sumByInt(it -> it.getLabel().getNumChildren());
            return (long)numLabels == numConstants;
        }
        return false;
    }

    default public boolean isEnumSwitch() {
        JTypeDeclSymbol type = this.getTestedExpression().getTypeMirror().getSymbol();
        return type instanceof JClassSymbol && ((JClassSymbol)type).isEnum();
    }

    @Override
    default public Iterator<ASTSwitchBranch> iterator() {
        return this.children(ASTSwitchBranch.class).iterator();
    }

    default public boolean isFallthroughSwitch() {
        return this.getBranches().filterIs(ASTSwitchFallthroughBranch.class).nonEmpty();
    }
}

