/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

@Deprecated
@InternalApi
public abstract class AbstractJUnitRule
extends AbstractJavaRule {
    protected static final String JUNIT3_CLASS_NAME = "junit.framework.TestCase";
    protected static final String JUNIT4_CLASS_NAME = "org.junit.Test";
    protected static final String JUNIT5_CLASS_NAME = "org.junit.jupiter.api.Test";
    protected boolean isJUnit3Class;
    protected boolean isJUnit4Class;
    protected boolean isJUnit5Class;
    private boolean isTestNgClass;

    public void start(RuleContext ctx) {
        super.start(ctx);
        this.isTestNgClass = false;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        if (node.getImportedName() != null && node.getImportedName().startsWith("org.testng")) {
            this.isTestNgClass = true;
        }
        return super.visit(node, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        boolean oldJUnit3Class = this.isJUnit3Class;
        boolean oldJUnit4Class = this.isJUnit4Class;
        boolean oldJUnit5Class = this.isJUnit5Class;
        try {
            this.analyzeJUnitClass(node);
            super.visit(node, data);
        }
        finally {
            this.isJUnit3Class = oldJUnit3Class;
            this.isJUnit4Class = oldJUnit4Class;
            this.isJUnit5Class = oldJUnit5Class;
        }
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        if (node.getFirstChildOfType(ASTMethodDeclaration.class) != null && !this.isJUnitTestClass()) {
            return data;
        }
        return super.visit(node, data);
    }

    protected boolean isJUnitTestClass() {
        return !this.isTestNgClass && (this.isJUnit3Class || this.isJUnit4Class || this.isJUnit5Class);
    }

    protected void analyzeJUnitClass(ASTClassOrInterfaceDeclaration node) {
        this.isJUnit3Class = AbstractJUnitRule.isJUnit3Class(node);
        this.isJUnit4Class = AbstractJUnitRule.isJUnit4Class(node);
        this.isJUnit5Class = AbstractJUnitRule.isJUnit5Class(node);
        if (this.isJUnit4Class && this.isJUnit5Class) {
            this.isJUnit4Class &= AbstractJUnitRule.hasImports(node, JUNIT4_CLASS_NAME);
            this.isJUnit5Class &= AbstractJUnitRule.hasImports(node, JUNIT5_CLASS_NAME);
        }
    }

    public static boolean isTestClass(ASTClassOrInterfaceBody node) {
        return !AbstractJUnitRule.isAbstractClass(node) && (AbstractJUnitRule.isTestClassJUnit3(node) || AbstractJUnitRule.isTestClassJUnit4(node) || AbstractJUnitRule.isTestClassJUnit5(node));
    }

    private static boolean isAbstractClass(ASTClassOrInterfaceBody node) {
        if (node.getParent() instanceof ASTClassOrInterfaceDeclaration) {
            ASTClassOrInterfaceDeclaration decl = (ASTClassOrInterfaceDeclaration)node.getParent();
            return decl.isAbstract();
        }
        return false;
    }

    public static boolean isTestClassJUnit3(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.isJUnit3Class(type);
        }
        return false;
    }

    public static boolean isTestClassJUnit4(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.isJUnit4Class(type) && AbstractJUnitRule.hasImports(type, JUNIT4_CLASS_NAME);
        }
        return false;
    }

    public static boolean isTestClassJUnit5(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.isJUnit5Class(type) && AbstractJUnitRule.hasImports(type, JUNIT5_CLASS_NAME);
        }
        return false;
    }

    public static boolean isTestMethod(ASTMethodDeclaration method) {
        if (method.isAbstract() || method.isNative() || method.isStatic()) {
            return false;
        }
        ASTClassOrInterfaceBody type = (ASTClassOrInterfaceBody)method.getFirstParentOfType(ASTClassOrInterfaceBody.class);
        return AbstractJUnitRule.isTestClassJUnit3(type) && method.isPublic() && method.isVoid() && method.getName().startsWith("test") || AbstractJUnitRule.isTestClassJUnit4(type) && method.isPublic() && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT4_CLASS_NAME) || AbstractJUnitRule.isTestClassJUnit5(type) && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT5_CLASS_NAME);
    }

    public boolean isJUnitMethod(ASTMethodDeclaration method, Object data) {
        if (method.isAbstract() || method.isNative() || method.isStatic()) {
            return false;
        }
        if (!this.isJUnit5Class && !method.isPublic()) {
            return false;
        }
        boolean result = false;
        result |= this.isJUnit3Method(method);
        result |= this.isJUnit4Method(method);
        return result |= this.isJUnit5Method(method);
    }

    private boolean isJUnit4Method(ASTMethodDeclaration method) {
        return this.isJUnit4Class && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT4_CLASS_NAME);
    }

    private boolean isJUnit5Method(ASTMethodDeclaration method) {
        return this.isJUnit5Class && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT5_CLASS_NAME);
    }

    private boolean isJUnit3Method(ASTMethodDeclaration method) {
        return this.isJUnit3Class && method.isVoid() && method.getName().startsWith("test");
    }

    private static boolean isJUnit3Class(TypeNode cid) {
        return TypeTestUtil.isA(JUNIT3_CLASS_NAME, cid);
    }

    private static boolean isJUnit4Class(JavaNode node) {
        return AbstractJUnitRule.doesNodeContainJUnitAnnotation(node, JUNIT4_CLASS_NAME);
    }

    private static boolean isJUnit5Class(JavaNode node) {
        return AbstractJUnitRule.doesNodeContainJUnitAnnotation(node, JUNIT5_CLASS_NAME);
    }

    private static boolean doesNodeContainJUnitAnnotation(JavaNode node, String annotationTypeClassName) {
        List annotations = node.findDescendantsOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            ASTName name;
            Node annotationTypeNode = annotation.getChild(0);
            TypeNode annotationType = (TypeNode)annotationTypeNode;
            if (!(annotationType.getType() == null ? (name = (ASTName)annotationTypeNode.getFirstChildOfType(ASTName.class)) != null && (name.hasImageEqualTo("Test") || name.hasImageEqualTo(annotationTypeClassName)) : TypeTestUtil.isA(annotationTypeClassName, annotationType))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasImports(JavaNode node, String className) {
        List imports = node.getRoot().findDescendantsOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration importDeclaration : imports) {
            ASTName name = (ASTName)importDeclaration.getFirstChildOfType(ASTName.class);
            if (name == null || !name.hasImageEqualTo(className)) continue;
            return true;
        }
        return false;
    }
}

