/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.Collection;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class AvoidInstantiatingObjectsInLoopsRule
extends AbstractJavaRule {
    public AvoidInstantiatingObjectsInLoopsRule() {
        this.addRuleChainVisit(ASTAllocationExpression.class);
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (this.notInsideLoop(node)) {
            return data;
        }
        if (this.fourthParentNotThrow(node) && this.fourthParentNotReturn(node) && this.notArrayAssignment(node) && this.notCollectionAccess(node) && this.notBreakFollowing(node)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean notArrayAssignment(ASTAllocationExpression node) {
        if (node.getNthParent(4) instanceof ASTStatementExpression) {
            ASTPrimaryExpression assignee = (ASTPrimaryExpression)node.getNthParent(4).getFirstChildOfType(ASTPrimaryExpression.class);
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)assignee.getFirstChildOfType(ASTPrimarySuffix.class);
            return suffix == null || !suffix.isArrayDereference();
        }
        return true;
    }

    private boolean notCollectionAccess(ASTAllocationExpression node) {
        if (node.getNthParent(4) instanceof ASTArgumentList && node.getNthParent(8) instanceof ASTStatementExpression) {
            ASTStatementExpression statement = (ASTStatementExpression)node.getNthParent(8);
            return !AvoidInstantiatingObjectsInLoopsRule.isCallOnReceiverOfType(Collection.class, statement);
        }
        return true;
    }

    private static boolean isCallOnReceiverOfType(Class<?> receiverType, JavaNode expression) {
        JavaNode lastChild;
        if ((expression instanceof ASTExpression || expression instanceof ASTStatementExpression) && expression.getNumChildren() == 1) {
            expression = expression.getChild(0);
        }
        int numChildren = expression.getNumChildren();
        if (expression instanceof ASTPrimaryExpression && numChildren >= 2 && (lastChild = expression.getChild(numChildren - 1)) instanceof ASTPrimarySuffix && ((ASTPrimarySuffix)lastChild).isArguments()) {
            JavaNode receiverExpr = expression.getChild(numChildren - 2);
            return receiverExpr instanceof TypeNode && TypeTestUtil.isA(receiverType, (TypeNode)receiverExpr);
        }
        return false;
    }

    private boolean notBreakFollowing(ASTAllocationExpression node) {
        ASTBlockStatement next;
        ASTBlock block;
        ASTBlockStatement blockStatement = (ASTBlockStatement)node.getFirstParentOfType(ASTBlockStatement.class);
        if (blockStatement != null && (block = (ASTBlock)blockStatement.getFirstParentOfType(ASTBlock.class)).getNumChildren() > blockStatement.getIndexInParent() + 1 && (next = (ASTBlockStatement)block.getChild(blockStatement.getIndexInParent() + 1)).getNumChildren() == 1 && ((JavaNode)next.getChild(0)).getNumChildren() == 1) {
            return !(((JavaNode)next.getChild(0)).getChild(0) instanceof ASTBreakStatement);
        }
        return true;
    }

    private boolean fourthParentNotThrow(ASTAllocationExpression node) {
        return !(node.getNthParent(4) instanceof ASTThrowStatement);
    }

    private boolean fourthParentNotReturn(ASTAllocationExpression node) {
        return !(node.getNthParent(4) instanceof ASTReturnStatement);
    }

    private boolean notInsideLoop(ASTAllocationExpression node) {
        for (Node n = node.getParent(); n != null; n = n.getParent()) {
            if (n instanceof ASTDoStatement || n instanceof ASTWhileStatement || n instanceof ASTForStatement) {
                return false;
            }
            if (n instanceof ASTForInit) {
                n = n.getParent();
                continue;
            }
            if (!(n.getParent() instanceof ASTForStatement) || n.getParent().getNumChildren() <= 1 || n != n.getParent().getChild(1)) continue;
            n = n.getParent();
        }
        return true;
    }
}

