/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.rule.design.ExcessiveNodeCountRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ExcessiveParameterListRule
extends ExcessiveNodeCountRule {
    private static final Integer COUNT = 1;
    private static final Integer SKIP = 0;

    public ExcessiveParameterListRule() {
        super(ASTFormalParameters.class);
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 10.0);
    }

    @Override
    public Object visit(ASTFormalParameters params, Object data) {
        if (this.areParametersOfPrivateConstructor(params)) {
            return SKIP;
        }
        return super.visit(params, data);
    }

    private boolean areParametersOfPrivateConstructor(ASTFormalParameters params) {
        Node parent = params.getParent();
        if (parent instanceof ASTConstructorDeclaration) {
            ASTConstructorDeclaration constructor = (ASTConstructorDeclaration)parent;
            return constructor.isPrivate();
        }
        return false;
    }

    @Override
    public Object visit(ASTFormalParameter param, Object data) {
        return COUNT;
    }
}

