/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class MethodNameDeclaration
extends AbstractNameDeclaration {
    public MethodNameDeclaration(ASTMethodDeclarator node) {
        super((ScopedNode)node);
    }

    public int getParameterCount() {
        return ((ASTMethodDeclarator)this.node).getParameterCount();
    }

    public boolean isVarargs() {
        ASTFormalParameters params = (ASTFormalParameters)this.node.getChild(0);
        if (params.size() == 0) {
            return false;
        }
        ASTFormalParameter p = (ASTFormalParameter)params.getChild(params.size() - 1);
        return p.isVarargs();
    }

    public ASTMethodDeclarator getMethodNameDeclaratorNode() {
        return (ASTMethodDeclarator)this.node;
    }

    public String getParameterDisplaySignature() {
        StringBuilder sb = new StringBuilder("(");
        ASTFormalParameters params = (ASTFormalParameters)this.node.getChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter p = (ASTFormalParameter)params.getChild(i);
            sb.append(p.getTypeNode().getTypeImage());
            if (p.isVarargs()) {
                sb.append("...");
            }
            sb.append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodNameDeclaration)) {
            return false;
        }
        MethodNameDeclaration other = (MethodNameDeclaration)((Object)o);
        if (!other.node.getImage().equals(this.node.getImage())) {
            return false;
        }
        if (((ASTMethodDeclarator)other.node).getParameterCount() != ((ASTMethodDeclarator)this.node).getParameterCount()) {
            return false;
        }
        ASTFormalParameters myParams = (ASTFormalParameters)this.node.getChild(0);
        ASTFormalParameters otherParams = (ASTFormalParameters)other.node.getChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            String otherTypeImg;
            String myTypeImg;
            ASTFormalParameter myParam = (ASTFormalParameter)myParams.getChild(i);
            ASTFormalParameter otherParam = (ASTFormalParameter)otherParams.getChild(i);
            if (myParam.isVarargs() != otherParam.isVarargs()) {
                return false;
            }
            Node myTypeNode = myParam.getTypeNode().getChild(0);
            Node otherTypeNode = otherParam.getTypeNode().getChild(0);
            if (myTypeNode.getClass() != otherTypeNode.getClass()) {
                return false;
            }
            if (myTypeNode instanceof ASTPrimitiveType) {
                myTypeImg = myTypeNode.getImage();
                otherTypeImg = otherTypeNode.getImage();
            } else {
                myTypeImg = myTypeNode.getChild(0).getImage();
                otherTypeImg = otherTypeNode.getChild(0).getImage();
            }
            if (myTypeImg.equals(otherTypeImg)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.node.getImage().hashCode() * 31 + ((ASTMethodDeclarator)this.node).getParameterCount();
        ASTFormalParameters myParams = (ASTFormalParameters)this.node.getChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter myParam = (ASTFormalParameter)myParams.getChild(i);
            Node myTypeNode = myParam.getTypeNode().getChild(0);
            String myTypeImg = myTypeNode instanceof ASTPrimitiveType ? myTypeNode.getImage() : myTypeNode.getChild(0).getImage();
            hash = hash * 31 + myTypeImg.hashCode();
        }
        return hash;
    }

    public String toString() {
        return "Method " + this.node.getImage() + ", line " + this.node.getBeginLine() + ", params = " + ((ASTMethodDeclarator)this.node).getParameterCount();
    }
}

