/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.Collection;
import java.util.Collections;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorReducedAdapter;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.util.designerbindings.DesignerBindings;

public final class JavaDesignerBindings
extends DesignerBindings.DefaultDesignerBindings {
    public static final JavaDesignerBindings INSTANCE = new JavaDesignerBindings();

    private JavaDesignerBindings() {
    }

    public Attribute getMainAttribute(Node node) {
        Attribute attr;
        if (node instanceof JavaNode && (attr = (Attribute)((JavaNode)node).jjtAccept(MainAttrVisitor.INSTANCE, null)) != null) {
            return attr;
        }
        return super.getMainAttribute(node);
    }

    public DesignerBindings.TreeIconId getIcon(Node node) {
        if (node instanceof ASTFieldDeclaration) {
            return DesignerBindings.TreeIconId.FIELD;
        }
        if (node instanceof ASTAnyTypeDeclaration) {
            return DesignerBindings.TreeIconId.CLASS;
        }
        if (node instanceof ASTMethodDeclaration) {
            return DesignerBindings.TreeIconId.METHOD;
        }
        if (node instanceof ASTConstructorDeclaration || node instanceof ASTRecordConstructorDeclaration) {
            return DesignerBindings.TreeIconId.CONSTRUCTOR;
        }
        if (node instanceof ASTVariableDeclaratorId) {
            return DesignerBindings.TreeIconId.VARIABLE;
        }
        return super.getIcon(node);
    }

    public Collection<DesignerBindings.AdditionalInfo> getAdditionalInfo(Node node) {
        Class<?> type;
        if (node instanceof TypeNode && (type = ((TypeNode)node).getType()) != null) {
            return Collections.singletonList(new DesignerBindings.AdditionalInfo("Type: " + type));
        }
        return super.getAdditionalInfo(node);
    }

    private static final class MainAttrVisitor
    extends JavaParserVisitorReducedAdapter {
        private static final JavaParserVisitor INSTANCE = new MainAttrVisitor();

        private MainAttrVisitor() {
        }

        @Override
        public Object visit(JavaNode node, Object data) {
            return null;
        }

        @Override
        public Object visit(ASTAnyTypeDeclaration node, Object data) {
            return new Attribute((Node)node, "SimpleName", node.getSimpleName());
        }

        @Override
        public Object visit(ASTMethodDeclaration node, Object data) {
            return new Attribute((Node)node, "Name", node.getName());
        }
    }
}

