/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class TooManyFieldsRule
extends AbstractJavaRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private static final PropertyDescriptor<Integer> MAX_FIELDS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxfields").desc("Max allowable fields")).defaultValue((Object)15)).require(NumericConstraints.positive())).build();

    public TooManyFieldsRule() {
        this.definePropertyDescriptor(MAX_FIELDS_DESCRIPTOR);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        int maxFields = (Integer)this.getProperty(MAX_FIELDS_DESCRIPTOR);
        int counter = 0;
        List l = node.findDescendantsOfType(ASTFieldDeclaration.class);
        for (ASTFieldDeclaration fd : l) {
            if (fd.isFinal() && fd.isStatic()) continue;
            ++counter;
        }
        if (counter > maxFields) {
            this.addViolation(data, node);
        }
        return data;
    }
}

