/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class PreserveStackTraceRule
extends AbstractJavaRule {
    private static final String FILL_IN_STACKTRACE = ".fillInStackTrace";

    @Override
    public Object visit(ASTCatchStatement catchStmt, Object data) {
        String target = ((ASTVariableDeclaratorId)((JavaNode)catchStmt.getChild(0)).findChildrenOfType(ASTVariableDeclaratorId.class).get(0)).getImage();
        List lstThrowStatements = catchStmt.findDescendantsOfType(ASTThrowStatement.class);
        for (ASTThrowStatement throwStatement : lstThrowStatements) {
            Node child;
            JavaNode n = ((JavaNode)throwStatement.getChild(0)).getChild(0);
            if (n instanceof ASTCastExpression) {
                ASTPrimaryExpression expr = (ASTPrimaryExpression)n.getChild(1);
                if (expr.getNumChildren() <= 1 || !(expr.getChild(1) instanceof ASTPrimaryPrefix)) continue;
                RuleContext ctx = (RuleContext)data;
                this.addViolation(ctx, (Node)throwStatement);
                continue;
            }
            ASTArgumentList args = (ASTArgumentList)throwStatement.getFirstDescendantOfType(ASTArgumentList.class);
            if (args != null) {
                JavaNode parent = ((JavaNode)args.getParent()).getParent();
                if (parent instanceof ASTAllocationExpression) {
                    this.ck(data, target, throwStatement, (Node)parent);
                    continue;
                }
                this.ck(data, target, throwStatement, (Node)throwStatement);
                continue;
            }
            for (child = throwStatement.getChild(0); child != null && child.getNumChildren() > 0 && !(child instanceof ASTName); child = child.getChild(0)) {
            }
            if (child == null) continue;
            if (child instanceof ASTName && !target.equals(child.getImage()) && !child.hasImageEqualTo(target + FILL_IN_STACKTRACE)) {
                Map vars = ((ASTName)child).getScope().getDeclarations(VariableNameDeclaration.class);
                for (Map.Entry entry : vars.entrySet()) {
                    ASTVariableInitializer initializer;
                    VariableNameDeclaration decl = (VariableNameDeclaration)entry.getKey();
                    List occurrences = (List)entry.getValue();
                    if (!decl.getImage().equals(child.getImage()) || this.isInitCauseCalled(target, occurrences) || (initializer = (ASTVariableInitializer)decl.getNode().getParent().getFirstDescendantOfType(ASTVariableInitializer.class)) == null) continue;
                    args = (ASTArgumentList)initializer.getFirstDescendantOfType(ASTArgumentList.class);
                    if (args != null) {
                        this.ck(data, target, throwStatement, (Node)args);
                        continue;
                    }
                    if (this.isFillInStackTraceCalled(target, initializer)) continue;
                    this.addViolation(data, (Node)throwStatement);
                }
                continue;
            }
            if (!(child instanceof ASTClassOrInterfaceType)) continue;
            this.addViolation(data, (Node)throwStatement);
        }
        return super.visit(catchStmt, data);
    }

    private boolean isFillInStackTraceCalled(String target, ASTVariableInitializer initializer) {
        ASTName astName = (ASTName)initializer.getFirstDescendantOfType(ASTName.class);
        return astName != null && astName.hasImageEqualTo(target + FILL_IN_STACKTRACE);
    }

    private boolean isInitCauseCalled(String target, List<NameOccurrence> occurrences) {
        boolean initCauseCalled = false;
        for (NameOccurrence occurrence : occurrences) {
            ASTArgumentList args2;
            ASTPrimaryExpression primaryExpression;
            String image = null;
            if (occurrence.getLocation() != null) {
                image = occurrence.getLocation().getImage();
            }
            if (image == null || !image.endsWith("initCause") || (primaryExpression = (ASTPrimaryExpression)occurrence.getLocation().getFirstParentOfType(ASTPrimaryExpression.class)) == null || !this.checkForTargetUsage(target, (Node)(args2 = (ASTArgumentList)primaryExpression.getFirstDescendantOfType(ASTArgumentList.class)))) continue;
            initCauseCalled = true;
            break;
        }
        return initCauseCalled;
    }

    private boolean checkForTargetUsage(String target, Node baseNode) {
        boolean match = false;
        if (target != null && baseNode != null) {
            List nameNodes = baseNode.findDescendantsOfType(ASTName.class, true);
            for (ASTName nameNode : nameNodes) {
                boolean isPartOfStringConcatenation;
                if (!target.equals(nameNode.getImage()) || (isPartOfStringConcatenation = this.isStringConcat((Node)nameNode, baseNode))) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    private boolean isStringConcat(Node childNode, Node baseNode) {
        Node currentNode = childNode;
        while (!Objects.equals(currentNode, baseNode)) {
            if (!((currentNode = currentNode.getParent()) instanceof ASTAdditiveExpression)) continue;
            return true;
        }
        return false;
    }

    private void ck(Object data, String target, ASTThrowStatement throwStatement, Node baseNode) {
        if (!this.checkForTargetUsage(target, baseNode)) {
            RuleContext ctx = (RuleContext)data;
            this.addViolation(ctx, (Node)throwStatement);
        }
    }
}

