/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;

public class NullAssignmentRule
extends AbstractJavaRule {
    public NullAssignmentRule() {
        this.addRuleChainVisit(ASTNullLiteral.class);
    }

    @Override
    public Object visit(ASTNullLiteral node, Object data) {
        if (node.getNthParent(5) instanceof ASTStatementExpression) {
            ASTStatementExpression n = (ASTStatementExpression)node.getNthParent(5);
            if (this.isAssignmentToFinalField(n)) {
                return data;
            }
            if (n.jjtGetNumChildren() > 2 && n.jjtGetChild(1) instanceof ASTAssignmentOperator) {
                this.addViolation(data, (Node)node);
            }
        } else if (node.getNthParent(4) instanceof ASTConditionalExpression) {
            if (this.isBadTernary((ASTConditionalExpression)node.getNthParent(4))) {
                this.addViolation(data, (Node)node);
            }
        } else if (node.getNthParent(5) instanceof ASTConditionalExpression && node.getNthParent(4) instanceof ASTExpression && this.isBadTernary((ASTConditionalExpression)node.getNthParent(5))) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean isAssignmentToFinalField(ASTStatementExpression n) {
        ASTName name = (ASTName)n.getFirstDescendantOfType(ASTName.class);
        return name != null && name.getNameDeclaration() instanceof VariableNameDeclaration && ((VariableNameDeclaration)name.getNameDeclaration()).getAccessNodeParent().isFinal();
    }

    private boolean isBadTernary(ASTConditionalExpression ternary) {
        boolean isInitializer = false;
        ASTVariableInitializer variableInitializer = (ASTVariableInitializer)ternary.getFirstParentOfType(ASTVariableInitializer.class);
        if (variableInitializer != null) {
            ASTBlockStatement statement = (ASTBlockStatement)ternary.getFirstParentOfType(ASTBlockStatement.class);
            isInitializer = statement == variableInitializer.getFirstParentOfType(ASTBlockStatement.class);
        }
        return !(ternary.jjtGetChild(0) instanceof ASTEqualityExpression) && !isInitializer && !(ternary.getNthParent(2) instanceof ASTReturnStatement) && !(ternary.getNthParent(2) instanceof ASTLambdaExpression);
    }
}

