/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;

public class InvalidSlf4jMessageFormatRule
extends AbstractJavaRule {
    private static final Logger LOG = Logger.getLogger(InvalidSlf4jMessageFormatRule.class.getName());
    private static final Set<String> LOGGER_LEVELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error")));
    private static final String LOGGER_CLASS = "org.slf4j.Logger";

    public InvalidSlf4jMessageFormatRule() {
        this.addRuleChainVisit(ASTName.class);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        NameDeclaration nameDeclaration = node.getNameDeclaration();
        if (!(nameDeclaration instanceof VariableNameDeclaration)) {
            return data;
        }
        Class<?> type = ((VariableNameDeclaration)nameDeclaration).getType();
        if (type == null || !type.getName().equals(LOGGER_CLASS)) {
            return data;
        }
        ASTPrimaryExpression parentNode = (ASTPrimaryExpression)node.getFirstParentOfType(ASTPrimaryExpression.class);
        String method = ((ASTName)((ASTPrimaryPrefix)parentNode.getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class)).getImage().replace(nameDeclaration.getImage() + ".", "");
        if (!LOGGER_LEVELS.contains(method)) {
            return data;
        }
        List argumentList = ((ASTArgumentList)((ASTPrimarySuffix)parentNode.getFirstChildOfType(ASTPrimarySuffix.class)).getFirstDescendantOfType(ASTArgumentList.class)).findChildrenOfType(ASTExpression.class);
        ASTExpression messageParam = (ASTExpression)argumentList.remove(0);
        int expectedArguments = this.expectedArguments(messageParam);
        if (expectedArguments == 0) {
            return data;
        }
        if (argumentList.size() > expectedArguments) {
            this.removeThrowableParam(argumentList);
        }
        if (argumentList.size() < expectedArguments) {
            this.addViolationWithMessage(data, (Node)node, "Missing arguments," + this.getExpectedMessage(argumentList, expectedArguments));
        } else if (argumentList.size() > expectedArguments) {
            this.addViolationWithMessage(data, (Node)node, "Too many arguments," + this.getExpectedMessage(argumentList, expectedArguments));
        }
        return data;
    }

    private boolean isNewThrowable(ASTPrimaryExpression last) {
        ASTClassOrInterfaceType classOrInterface = (ASTClassOrInterfaceType)last.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        return classOrInterface != null && classOrInterface.getType() != null && TypeHelper.isA((TypeNode)classOrInterface, Throwable.class);
    }

    private boolean hasTypeThrowable(ASTPrimaryExpression last) {
        return last.getType() != null && TypeHelper.isA((TypeNode)last, Throwable.class);
    }

    private boolean isReferencingThrowable(ASTPrimaryExpression last) {
        ASTName variable = (ASTName)last.getFirstDescendantOfType(ASTName.class);
        if (variable != null && variable.getNameDeclaration() != null && variable.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration declaration = (VariableNameDeclaration)variable.getNameDeclaration();
            if (declaration.getType() != null && Throwable.class.isAssignableFrom(declaration.getType())) {
                return true;
            }
            if (declaration.getTypeImage() != null && declaration.getTypeImage().endsWith("Exception")) {
                return true;
            }
        }
        return false;
    }

    private void removeThrowableParam(List<ASTExpression> params) {
        if (params.isEmpty()) {
            return;
        }
        int lastIndex = params.size() - 1;
        ASTPrimaryExpression last = (ASTPrimaryExpression)params.get(lastIndex).getFirstDescendantOfType(ASTPrimaryExpression.class);
        if (this.isNewThrowable(last) || this.hasTypeThrowable(last) || this.isReferencingThrowable(last)) {
            params.remove(lastIndex);
        }
    }

    private String getExpectedMessage(List<ASTExpression> params, int expectedArguments) {
        return " expected " + expectedArguments + (expectedArguments > 1 ? " arguments " : " argument ") + "but have " + params.size();
    }

    private int expectedArguments(ASTExpression node) {
        int count = 0;
        if (node.getFirstDescendantOfType(ASTLiteral.class) != null) {
            count = this.countPlaceholders(node);
        } else if (node.getFirstDescendantOfType(ASTName.class) != null) {
            String variableName = ((ASTName)node.getFirstDescendantOfType(ASTName.class)).getImage();
            JavaNode parentBlock = (JavaNode)node.getFirstParentOfAnyType(new Class[]{ASTMethodOrConstructorDeclaration.class, ASTInitializer.class, ASTLambdaExpression.class});
            if (parentBlock != null) {
                List localVariables = parentBlock.findDescendantsOfType(ASTVariableDeclarator.class);
                count = this.getAmountOfExpectedArguments(variableName, localVariables);
            }
            if (count == 0) {
                List fieldlist = ((AbstractJavaNode)node.getFirstParentOfAnyType(new Class[]{ASTClassOrInterfaceBody.class, ASTEnumBody.class})).findDescendantsOfType(ASTFieldDeclaration.class);
                ArrayList<ASTVariableDeclarator> fields = new ArrayList<ASTVariableDeclarator>(fieldlist.size());
                for (ASTFieldDeclaration astFieldDeclaration : fieldlist) {
                    fields.add((ASTVariableDeclarator)astFieldDeclaration.getFirstChildOfType(ASTVariableDeclarator.class));
                }
                count = this.getAmountOfExpectedArguments(variableName, fields);
            }
        }
        return count;
    }

    private int getAmountOfExpectedArguments(String variableName, List<ASTVariableDeclarator> variables) {
        for (ASTVariableDeclarator astVariableDeclarator : variables) {
            if (!((ASTVariableDeclaratorId)astVariableDeclarator.getFirstChildOfType(ASTVariableDeclaratorId.class)).getImage().equals(variableName)) continue;
            ASTVariableInitializer variableInitializer = (ASTVariableInitializer)astVariableDeclarator.getFirstDescendantOfType(ASTVariableInitializer.class);
            ASTExpression expression = null;
            if (variableInitializer != null) {
                expression = (ASTExpression)variableInitializer.getFirstChildOfType(ASTExpression.class);
            }
            if (expression == null) continue;
            return this.countPlaceholders(expression);
        }
        return 0;
    }

    private int countPlaceholders(ASTExpression node) {
        int result = 0;
        try {
            List literals = node.findChildNodesWithXPath("AdditiveExpression/PrimaryExpression/PrimaryPrefix/Literal[@StringLiteral='true']|PrimaryExpression/PrimaryPrefix/Literal[@StringLiteral='true']");
            for (Node stringLiteral : literals) {
                result += StringUtils.countMatches((CharSequence)stringLiteral.getImage(), (CharSequence)"{}");
            }
        }
        catch (JaxenException e) {
            LOG.log(Level.FINE, "Could not determine literals", e);
        }
        return result;
    }
}

