/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class AvoidCallingFinalizeRule
extends AbstractJavaRule {
    private Set<MethodScope> checked = new HashSet<MethodScope>();

    @Override
    public Object visit(ASTCompilationUnit acu, Object ctx) {
        this.checked.clear();
        return super.visit(acu, ctx);
    }

    @Override
    public Object visit(ASTName name, Object ctx) {
        if (name.getImage() == null || !name.getImage().endsWith("finalize")) {
            return ctx;
        }
        if (!this.checkForViolation(name)) {
            return ctx;
        }
        this.addViolation(ctx, (Node)name);
        return ctx;
    }

    @Override
    public Object visit(ASTPrimaryPrefix pp, Object ctx) {
        List primarySuffixes = pp.jjtGetParent().findChildrenOfType(ASTPrimarySuffix.class);
        ASTPrimarySuffix firstSuffix = null;
        if (!primarySuffixes.isEmpty()) {
            firstSuffix = (ASTPrimarySuffix)primarySuffixes.get(0);
        }
        if (firstSuffix == null || firstSuffix.getImage() == null || !firstSuffix.getImage().endsWith("finalize")) {
            return super.visit(pp, ctx);
        }
        if (!this.checkForViolation(pp)) {
            return super.visit(pp, ctx);
        }
        this.addViolation(ctx, (Node)pp);
        return super.visit(pp, ctx);
    }

    private boolean checkForViolation(ScopedNode node) {
        MethodScope meth = (MethodScope)node.getScope().getEnclosingScope(MethodScope.class);
        if (meth != null && "finalize".equals(meth.getName())) {
            return false;
        }
        if (meth != null && this.checked.contains((Object)meth)) {
            return false;
        }
        if (meth != null) {
            this.checked.add(meth);
        }
        return true;
    }
}

