/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UselessOverridingMethodRule
extends AbstractJavaRule {
    private final List<String> exceptions;
    private boolean ignoreAnnotations;
    private static final String CLONE = "clone";
    private static final String OBJECT = "Object";
    private static final PropertyDescriptor<Boolean> IGNORE_ANNOTATIONS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreAnnotations").defaultValue((Object)false)).desc("Ignore annotations")).build();

    public UselessOverridingMethodRule() {
        this.definePropertyDescriptor(IGNORE_ANNOTATIONS_DESCRIPTOR);
        this.exceptions = new ArrayList<String>(1);
        this.exceptions.add("CloneNotSupportedException");
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    private void init() {
        this.ignoreAnnotations = (Boolean)this.getProperty(IGNORE_ANNOTATIONS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration clz, Object data) {
        if (clz.isInterface()) {
            return data;
        }
        return super.visit(clz, data);
    }

    private boolean isMethodType(ASTMethodDeclaration node, String methodType) {
        boolean result = false;
        ASTResultType type = node.getResultType();
        if (type != null) {
            result = type.hasDescendantMatchingXPath("./Type/ReferenceType/ClassOrInterfaceType[@Image = '" + methodType + "']");
        }
        return result;
    }

    private boolean isMethodThrowingType(ASTMethodDeclaration node, List<String> exceptedExceptions) {
        boolean result = false;
        ASTNameList thrownsExceptions = (ASTNameList)node.getFirstChildOfType(ASTNameList.class);
        if (thrownsExceptions != null) {
            List names = thrownsExceptions.findChildrenOfType(ASTName.class);
            for (ASTName name : names) {
                for (String exceptedException : exceptedExceptions) {
                    if (!exceptedException.equals(name.getImage())) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean hasArguments(ASTMethodDeclaration node) {
        return node.hasDescendantMatchingXPath("./MethodDeclarator/FormalParameters/*");
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        int i;
        ASTPrimaryExpression primaryExpression;
        if (node.isAbstract() || node.isFinal() || node.isNative() || node.isSynchronized()) {
            return super.visit(node, data);
        }
        if (CLONE.equals(node.getMethodName()) && node.isPublic() && !this.hasArguments(node) && this.isMethodType(node, OBJECT) && this.isMethodThrowingType(node, this.exceptions)) {
            return super.visit(node, data);
        }
        ASTBlock block = node.getBlock();
        if (block == null) {
            return super.visit(node, data);
        }
        if (block.jjtGetNumChildren() != 1 || block.findDescendantsOfType(ASTStatement.class).size() != 1) {
            return super.visit(node, data);
        }
        Node statement = block.jjtGetChild(0).jjtGetChild(0);
        if (statement.jjtGetChild(0).jjtGetNumChildren() == 0) {
            return data;
        }
        Node statementGrandChild = statement.jjtGetChild(0).jjtGetChild(0);
        if (statementGrandChild instanceof ASTPrimaryExpression) {
            primaryExpression = (ASTPrimaryExpression)statementGrandChild;
        } else {
            List<ASTPrimaryExpression> primaryExpressions = this.findFirstDegreeChildrenOfType(statementGrandChild, ASTPrimaryExpression.class);
            if (primaryExpressions.size() != 1) {
                return super.visit(node, data);
            }
            primaryExpression = primaryExpressions.get(0);
        }
        ASTPrimaryPrefix primaryPrefix = this.findFirstDegreeChildrenOfType((Node)primaryExpression, ASTPrimaryPrefix.class).get(0);
        if (!primaryPrefix.usesSuperModifier()) {
            return super.visit(node, data);
        }
        List<ASTPrimarySuffix> primarySuffixList = this.findFirstDegreeChildrenOfType((Node)primaryExpression, ASTPrimarySuffix.class);
        if (primarySuffixList.size() != 2) {
            return super.visit(node, data);
        }
        ASTMethodDeclarator methodDeclarator = this.findFirstDegreeChildrenOfType(node, ASTMethodDeclarator.class).get(0);
        ASTPrimarySuffix primarySuffix = primarySuffixList.get(0);
        if (!primarySuffix.hasImageEqualTo(methodDeclarator.getImage())) {
            return super.visit(node, data);
        }
        primarySuffix = primarySuffixList.get(1);
        ASTArguments arguments = (ASTArguments)primarySuffix.jjtGetChild(0);
        ASTFormalParameters formalParameters = (ASTFormalParameters)methodDeclarator.jjtGetChild(0);
        if (formalParameters.jjtGetNumChildren() != arguments.jjtGetNumChildren()) {
            return super.visit(node, data);
        }
        if (!this.ignoreAnnotations) {
            ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.jjtGetParent();
            for (i = 0; i < parent.jjtGetNumChildren(); ++i) {
                Node n = parent.jjtGetChild(i);
                if (!(n instanceof ASTAnnotation) || n.jjtGetChild(0) instanceof ASTMarkerAnnotation && "Override".equals(((ASTName)n.jjtGetChild(0).jjtGetChild(0)).getImage())) continue;
                return super.visit(node, data);
            }
        }
        if (arguments.jjtGetNumChildren() == 0) {
            this.addViolation(data, node, this.getMessage());
        } else {
            ASTArgumentList argumentList = (ASTArgumentList)arguments.jjtGetChild(0);
            for (i = 0; i < argumentList.jjtGetNumChildren(); ++i) {
                Node expressionChild = argumentList.jjtGetChild(i).jjtGetChild(0);
                if (!(expressionChild instanceof ASTPrimaryExpression) || expressionChild.jjtGetNumChildren() != 1) {
                    return super.visit(node, data);
                }
                ASTPrimaryExpression argumentPrimaryExpression = (ASTPrimaryExpression)expressionChild;
                ASTPrimaryPrefix argumentPrimaryPrefix = (ASTPrimaryPrefix)argumentPrimaryExpression.jjtGetChild(0);
                if (argumentPrimaryPrefix.jjtGetNumChildren() == 0) {
                    return super.visit(node, data);
                }
                Node argumentPrimaryPrefixChild = argumentPrimaryPrefix.jjtGetChild(0);
                if (!(argumentPrimaryPrefixChild instanceof ASTName)) {
                    return super.visit(node, data);
                }
                if (formalParameters.jjtGetNumChildren() < i + 1) {
                    return super.visit(node, data);
                }
                ASTName argumentName = (ASTName)argumentPrimaryPrefixChild;
                ASTFormalParameter formalParameter = (ASTFormalParameter)formalParameters.jjtGetChild(i);
                ASTVariableDeclaratorId variableId = this.findFirstDegreeChildrenOfType(formalParameter, ASTVariableDeclaratorId.class).get(0);
                if (argumentName.hasImageEqualTo(variableId.getImage())) continue;
                return super.visit(node, data);
            }
            this.addViolation(data, node, this.getMessage());
        }
        return super.visit(node, data);
    }

    public <T> List<T> findFirstDegreeChildrenOfType(Node n, Class<T> targetType) {
        ArrayList l = new ArrayList();
        this.lclFindChildrenOfType(n, targetType, l);
        return l;
    }

    private <T> void lclFindChildrenOfType(Node node, Class<T> targetType, List<T> results) {
        if (node.getClass().equals(targetType)) {
            results.add(node);
        }
        if (node instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node).isNested()) {
            return;
        }
        if (node instanceof ASTClassOrInterfaceBodyDeclaration && ((ASTClassOrInterfaceBodyDeclaration)node).isAnonymousInnerClass()) {
            return;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (!child.getClass().equals(targetType)) continue;
            results.add(child);
        }
    }
}

