/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class PrematureDeclarationRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        if (node.jjtGetParent() instanceof ASTForInit) {
            return super.visit(node, data);
        }
        block0: for (ASTVariableDeclaratorId id : node) {
            for (ASTBlockStatement block : PrematureDeclarationRule.statementsAfter(node)) {
                if (PrematureDeclarationRule.hasReferencesIn(block, id.getVariableName())) break;
                if (!this.hasExit(block)) continue;
                this.addViolation(data, node);
                continue block0;
            }
        }
        return super.visit(node, data);
    }

    private boolean hasExit(ASTBlockStatement block) {
        return block.hasDescendantOfAnyType(new Class[]{ASTThrowStatement.class, ASTReturnStatement.class});
    }

    private static boolean hasReferencesIn(ASTBlockStatement block, String varName) {
        for (ASTName name : block.findDescendantsOfType(ASTName.class, true)) {
            if (!PrematureDeclarationRule.isReference(varName, name.getImage())) continue;
            return true;
        }
        return false;
    }

    private static boolean isReference(String shortName, String compoundName) {
        int dotPos = compoundName.indexOf(46);
        return dotPos < 0 ? shortName.equals(compoundName) : shortName.equals(compoundName.substring(0, dotPos));
    }

    private static List<ASTBlockStatement> statementsAfter(ASTLocalVariableDeclaration node) {
        Node blockOrSwitch = node.jjtGetParent().jjtGetParent();
        int count = blockOrSwitch.jjtGetNumChildren();
        int start = node.jjtGetParent().jjtGetChildIndex() + 1;
        ArrayList<ASTBlockStatement> nextBlocks = new ArrayList<ASTBlockStatement>(count - start);
        for (int i = start; i < count; ++i) {
            Node maybeBlock = blockOrSwitch.jjtGetChild(i);
            if (!(maybeBlock instanceof ASTBlockStatement)) continue;
            nextBlocks.add((ASTBlockStatement)maybeBlock);
        }
        return nextBlocks;
    }
}

