/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.rule.AbstractJUnitRule;

public class JUnitAssertionsShouldIncludeMessageRule
extends AbstractJUnitRule {
    private List<AssertionCall> checks = new ArrayList<AssertionCall>();

    public JUnitAssertionsShouldIncludeMessageRule() {
        this.checks.add(new AssertionCall("assertArrayEquals", 2));
        this.checks.add(new AssertionCall("assertEquals", 2));
        this.checks.add(new AssertionCall("assertFalse", 1));
        this.checks.add(new AssertionCall("assertNotNull", 1));
        this.checks.add(new AssertionCall("assertNotSame", 2));
        this.checks.add(new AssertionCall("assertNull", 1));
        this.checks.add(new AssertionCall("assertSame", 2));
        this.checks.add(new AssertionCall("assertThat", 2));
        this.checks.add(new AssertionCall("assertTrue", 1));
        this.checks.add(new AssertionCall("fail", 0));
        this.checks.add(new AssertionCall("assertEquals", 3){

            @Override
            protected boolean isException(ASTArguments node) {
                List arguments = node.findDescendantsOfType(ASTExpression.class);
                boolean isExceptionJunit4 = JUnitAssertionsShouldIncludeMessageRule.this.isStringTypeOrNull((ASTExpression)arguments.get(0));
                boolean isExceptionJunit5 = JUnitAssertionsShouldIncludeMessageRule.this.isStringTypeOrNull((ASTExpression)arguments.get(2));
                return isExceptionJunit4 || isExceptionJunit5;
            }
        });
    }

    @Override
    public Object visit(ASTArguments node, Object data) {
        for (AssertionCall call : this.checks) {
            call.check(data, node);
        }
        return super.visit(node, data);
    }

    private boolean isStringTypeOrNull(ASTExpression node) {
        return node.getType() == String.class || node.getType() == null;
    }

    private class AssertionCall {
        private final int argumentsCount;
        private final String assertionName;

        AssertionCall(String assertionName, int argumentsCount) {
            this.argumentsCount = argumentsCount;
            this.assertionName = assertionName;
        }

        public void check(Object ctx, ASTArguments node) {
            ASTName name;
            ASTPrimaryPrefix primaryPrefix;
            if (node.getArgumentCount() == this.argumentsCount && node.getNthParent(2) instanceof ASTPrimaryExpression && (primaryPrefix = (ASTPrimaryPrefix)node.getNthParent(2).getFirstChildOfType(ASTPrimaryPrefix.class)) != null && (name = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class)) != null && name.hasImageEqualTo(this.assertionName)) {
                if (this.isException(node)) {
                    return;
                }
                JUnitAssertionsShouldIncludeMessageRule.this.addViolation(ctx, (Node)name);
            }
        }

        protected boolean isException(ASTArguments node) {
            return false;
        }
    }
}

