/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Iterator;
import net.sourceforge.pmd.lang.ast.Node;

class NodeChildrenIterator<T extends Node>
implements Iterator<T> {
    private final Node parent;
    private final Class<T> targetChildType;
    private int i = 0;

    NodeChildrenIterator(Node parent, Class<T> targetChildType) {
        this.parent = parent;
        this.targetChildType = targetChildType;
    }

    private void moveToNext() {
        while (this.i < this.parent.jjtGetNumChildren() && !this.targetChildType.isInstance(this.parent.jjtGetChild(this.i))) {
            ++this.i;
        }
    }

    @Override
    public boolean hasNext() {
        this.moveToNext();
        return this.i < this.parent.jjtGetNumChildren();
    }

    @Override
    public T next() {
        this.moveToNext();
        Node t = this.parent.jjtGetChild(this.i++);
        return (T)t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

