/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.performance.InefficientStringBufferingRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class ConsecutiveLiteralAppendsRule
extends AbstractJavaRule {
    private static final Set<Class<?>> BLOCK_PARENTS = new HashSet();
    private static final PropertyDescriptor<Integer> THRESHOLD_DESCRIPTOR;
    private int threshold = 1;

    public ConsecutiveLiteralAppendsRule() {
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        Node lastBlock;
        if (!ConsecutiveLiteralAppendsRule.isStringBuilderOrBuffer(node)) {
            return data;
        }
        this.threshold = (Integer)this.getProperty(THRESHOLD_DESCRIPTOR);
        int concurrentCount = this.checkConstructor(node, data);
        if (this.hasInitializer(node)) {
            concurrentCount += this.checkInitializerExpressions(node);
        }
        Node currentBlock = lastBlock = this.getFirstParentBlock(node);
        ASTVariableDeclaratorId rootNode = null;
        if (concurrentCount >= 1) {
            rootNode = node;
        }
        List<NameOccurrence> usages = this.determineUsages(node);
        for (NameOccurrence no : usages) {
            JavaNameOccurrence jno = (JavaNameOccurrence)no;
            JavaNode n = jno.getLocation();
            currentBlock = this.getFirstParentBlock((Node)n);
            if (InefficientStringBufferingRule.isInStringBufferOperation((Node)n, 3, "append")) {
                ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(ASTPrimaryExpression.class);
                int numChildren = s.jjtGetNumChildren();
                for (int jx = 0; jx < numChildren; ++jx) {
                    Node sn = s.jjtGetChild(jx);
                    if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                    if (currentBlock != null && lastBlock != null && !currentBlock.equals(lastBlock) || currentBlock == null ^ lastBlock == null) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    }
                    if (concurrentCount == 0) {
                        rootNode = sn;
                    }
                    if (this.isAdditive(sn)) {
                        if ((concurrentCount = this.processAdditive(data, concurrentCount, sn, rootNode)) != 0) {
                            rootNode = sn;
                        }
                    } else if (!this.isAppendingStringLiteral(sn)) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    } else {
                        ++concurrentCount;
                    }
                    lastBlock = currentBlock;
                }
                continue;
            }
            if (n.getImage().endsWith(".toString") || n.getImage().endsWith(".length")) continue;
            this.checkForViolation(rootNode, data, concurrentCount);
            concurrentCount = 0;
        }
        this.checkForViolation(rootNode, data, concurrentCount);
        return data;
    }

    private List<NameOccurrence> determineUsages(ASTVariableDeclaratorId node) {
        Map decls = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : decls.entrySet()) {
            if (!node.hasImageEqualTo(((VariableNameDeclaration)entry.getKey()).getName())) continue;
            return (List)entry.getValue();
        }
        return Collections.emptyList();
    }

    private int checkConstructor(ASTVariableDeclaratorId node, Object data) {
        Node parent = node.jjtGetParent();
        if (parent.jjtGetNumChildren() >= 2) {
            ASTAllocationExpression allocationExpression = (ASTAllocationExpression)parent.jjtGetChild(1).getFirstDescendantOfType(ASTAllocationExpression.class);
            ASTArgumentList list = null;
            if (allocationExpression != null) {
                list = (ASTArgumentList)allocationExpression.getFirstDescendantOfType(ASTArgumentList.class);
            }
            if (list != null) {
                ASTLiteral literal = (ASTLiteral)list.getFirstDescendantOfType(ASTLiteral.class);
                if (!this.isAdditive((Node)list) && literal != null && literal.isStringLiteral()) {
                    return 1;
                }
                return this.processAdditive(data, 0, (Node)list, node);
            }
        }
        return 0;
    }

    private int checkInitializerExpressions(ASTVariableDeclaratorId node) {
        ASTVariableInitializer initializer = (ASTVariableInitializer)node.jjtGetParent().getFirstChildOfType(ASTVariableInitializer.class);
        ASTPrimaryExpression primary = (ASTPrimaryExpression)initializer.getFirstDescendantOfType(ASTPrimaryExpression.class);
        int result = 0;
        boolean previousWasAppend = false;
        for (int i = 0; i < primary.jjtGetNumChildren(); ++i) {
            Node child = primary.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0 && child.jjtGetChild(0) instanceof ASTAllocationExpression || !(child instanceof ASTPrimarySuffix)) continue;
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)child;
            if (suffix.jjtGetNumChildren() == 0 && suffix.hasImageEqualTo("append")) {
                previousWasAppend = true;
                continue;
            }
            if (suffix.jjtGetNumChildren() <= 0 || !previousWasAppend) continue;
            previousWasAppend = false;
            ASTLiteral literal = (ASTLiteral)suffix.getFirstDescendantOfType(ASTLiteral.class);
            if (literal == null || !literal.isStringLiteral()) break;
            ++result;
        }
        return result;
    }

    private boolean hasInitializer(ASTVariableDeclaratorId node) {
        return node.jjtGetParent().hasDescendantOfType(ASTVariableInitializer.class);
    }

    private int processAdditive(Object data, int concurrentCount, Node sn, Node rootNode) {
        ASTAdditiveExpression additive = (ASTAdditiveExpression)sn.getFirstDescendantOfType(ASTAdditiveExpression.class);
        if (additive == null || additive.getType() != null && !TypeHelper.isA((TypeNode)additive, String.class)) {
            return 0;
        }
        List literals = additive.findDescendantsOfType(ASTLiteral.class);
        boolean stringLiteralFound = false;
        for (ASTLiteral l : literals) {
            if (!l.isCharLiteral() && !l.isStringLiteral()) continue;
            stringLiteralFound = true;
            break;
        }
        if (!stringLiteralFound) {
            return 0;
        }
        int count = concurrentCount;
        boolean found = false;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            Node childNode = additive.jjtGetChild(ix);
            if (childNode.jjtGetNumChildren() != 1 || childNode.hasDescendantOfType(ASTName.class)) {
                if (!found) {
                    this.checkForViolation(rootNode, data, count);
                    found = true;
                }
                count = 0;
                continue;
            }
            ++count;
        }
        if (!found) {
            count = 1;
        }
        return count;
    }

    private boolean isAdditive(Node n) {
        List lstAdditive = n.findDescendantsOfType(ASTAdditiveExpression.class);
        if (lstAdditive.isEmpty()) {
            return false;
        }
        for (int ix = 0; ix < lstAdditive.size(); ++ix) {
            ASTAdditiveExpression expr = (ASTAdditiveExpression)lstAdditive.get(ix);
            if (expr.getParentsOfType(ASTArgumentList.class).size() == 1) continue;
            return false;
        }
        return true;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !BLOCK_PARENTS.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode instanceof ASTIfStatement) {
            parentNode = lastNode;
        } else if (parentNode instanceof ASTSwitchStatement) {
            parentNode = this.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        Object result = parentNode;
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = result.jjtGetChild(ix);
            if (n instanceof ASTSwitchLabel) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            result = label;
            break;
        }
        return result;
    }

    private void checkForViolation(Node node, Object data, int concurrentCount) {
        if (concurrentCount > this.threshold) {
            Object[] param = new String[]{String.valueOf(concurrentCount)};
            this.addViolation(data, node, param);
        }
    }

    private boolean isAppendingStringLiteral(Node node) {
        Node n = node;
        while (n.jjtGetNumChildren() != 0 && !(n instanceof ASTLiteral)) {
            n = n.jjtGetChild(0);
        }
        return n instanceof ASTLiteral;
    }

    private static boolean isStringBuilderOrBuffer(ASTVariableDeclaratorId node) {
        if (node.getType() != null) {
            return TypeHelper.isEither(node, StringBuffer.class, StringBuilder.class);
        }
        Node nn = node.getTypeNameNode();
        if (nn == null || nn.jjtGetNumChildren() == 0) {
            return false;
        }
        return TypeHelper.isEither((TypeNode)nn.jjtGetChild(0), StringBuffer.class, StringBuilder.class);
    }

    static {
        BLOCK_PARENTS.add(ASTForStatement.class);
        BLOCK_PARENTS.add(ASTWhileStatement.class);
        BLOCK_PARENTS.add(ASTDoStatement.class);
        BLOCK_PARENTS.add(ASTIfStatement.class);
        BLOCK_PARENTS.add(ASTSwitchStatement.class);
        BLOCK_PARENTS.add(ASTMethodDeclaration.class);
        BLOCK_PARENTS.add(ASTCatchStatement.class);
        BLOCK_PARENTS.add(ASTFinallyStatement.class);
        THRESHOLD_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"threshold").desc("Max consecutive appends")).require(NumericConstraints.inRange((Number)1, (Number)10))).defaultValue((Object)1)).build();
    }
}

