/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.qname;

import java.util.Objects;
import net.sourceforge.pmd.lang.java.ast.JavaQualifiedName;
import net.sourceforge.pmd.lang.java.qname.JavaTypeQualifiedName;

public final class JavaOperationQualifiedName
extends JavaQualifiedName {
    private final JavaTypeQualifiedName parent;
    private final String operation;
    private final boolean isLambda;

    JavaOperationQualifiedName(JavaTypeQualifiedName parent, String operation, boolean isLambda) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(parent);
        this.parent = parent;
        this.operation = operation;
        this.isLambda = isLambda;
    }

    @Override
    public JavaTypeQualifiedName getClassName() {
        return this.parent;
    }

    public boolean isOperation() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isLambda() {
        return this.isLambda;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    protected boolean structurallyEquals(JavaQualifiedName qname) {
        JavaOperationQualifiedName that = (JavaOperationQualifiedName)qname;
        return this.isLambda == that.isLambda && this.operation.equals(that.operation) && this.parent.equals(that.parent);
    }

    @Override
    protected int buildHashCode() {
        return this.parent.hashCode() * 31 + Objects.hash(this.isLambda, this.operation);
    }

    @Override
    protected String buildToString() {
        return this.parent.toString() + "#" + this.operation;
    }
}

