/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.basic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class CheckResultSetRule
extends AbstractJavaRule {
    private Map<String, Node> resultSetVariables = new HashMap<String, Node>();
    private static Set<String> methods = new HashSet<String>();

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.resultSetVariables.clear();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTVariableDeclarator declarator;
        ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)((ASTType)node.getFirstChildOfType(ASTType.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (type != null && (type.getType() != null && "java.sql.ResultSet".equals(type.getType().getName()) || "ResultSet".equals(type.getImage())) && (declarator = (ASTVariableDeclarator)node.getFirstChildOfType(ASTVariableDeclarator.class)) != null) {
            ASTName name = (ASTName)declarator.getFirstDescendantOfType(ASTName.class);
            if (type.getType() != null || name != null && name.getImage().endsWith("executeQuery")) {
                ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)declarator.getFirstChildOfType(ASTVariableDeclaratorId.class);
                this.resultSetVariables.put(id.getImage(), node);
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        String image = node.getImage();
        String var = this.getResultSetVariableName(image);
        if (var != null && this.resultSetVariables.containsKey(var) && node.getFirstParentOfType(ASTIfStatement.class) == null && node.getFirstParentOfType(ASTWhileStatement.class) == null && node.getFirstParentOfType(ASTReturnStatement.class) == null) {
            this.addViolation(data, this.resultSetVariables.get(var));
        }
        return super.visit(node, data);
    }

    private String getResultSetVariableName(String image) {
        if (image.contains(".")) {
            for (String method : methods) {
                if (!image.endsWith(method)) continue;
                return image.substring(0, image.lastIndexOf(method));
            }
        }
        return null;
    }

    static {
        methods.add(".next");
        methods.add(".previous");
        methods.add(".last");
        methods.add(".first");
    }
}

