/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Applier;
import net.sourceforge.pmd.lang.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.SearchFunction;

public class MethodScope
extends AbstractJavaScope {
    private Node node;

    public MethodScope(Node node) {
        this.node = node;
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public Set<NameDeclaration> addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        Set<NameDeclaration> declarations = this.findVariableHere(javaOccurrence);
        if (!declarations.isEmpty() && !javaOccurrence.isThisOrSuper()) {
            for (NameDeclaration decl : declarations) {
                this.getVariableDeclarations().get(decl).add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (!(n instanceof ASTName)) continue;
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return declarations;
    }

    @Override
    public void addDeclaration(NameDeclaration variableDecl) {
        if (!(variableDecl instanceof VariableNameDeclaration) && !(variableDecl instanceof ClassNameDeclaration)) {
            throw new IllegalArgumentException("A MethodScope can contain only VariableNameDeclarations or ClassNameDeclarations");
        }
        super.addDeclaration(variableDecl);
    }

    @Override
    public Set<NameDeclaration> findVariableHere(JavaNameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return Collections.emptySet();
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply((SearchFunction)finder, this.getVariableDeclarations().keySet().iterator());
        if (finder.getDecl() != null) {
            return Collections.singleton(finder.getDecl());
        }
        return Collections.emptySet();
    }

    public String getName() {
        if (this.node instanceof ASTConstructorDeclaration) {
            return ((ClassScope)this.getEnclosingScope(ClassScope.class)).getClassName();
        }
        return this.node.jjtGetChild(1).getImage();
    }

    public String toString() {
        return "MethodScope:" + this.glomNames(this.getVariableDeclarations().keySet());
    }
}

