/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.rule.AbstractInefficientZeroCheck;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.CollectionUtil;

public class UseCollectionIsEmptyRule
extends AbstractInefficientZeroCheck {
    @Override
    public boolean appliesToClassName(String name) {
        return CollectionUtil.isCollectionType((String)name, (boolean)true);
    }

    @Override
    public boolean isTargetMethod(JavaNameOccurrence occ) {
        return occ.getNameForWhichThisIsAQualifier() != null && occ.getLocation().getImage().endsWith(".size");
    }

    @Override
    public Map<String, List<String>> getComparisonTargets() {
        HashMap<String, List<String>> rules = new HashMap<String, List<String>>();
        rules.put("<", Arrays.asList("0", "1"));
        rules.put(">", Arrays.asList("0"));
        rules.put("==", Arrays.asList("0"));
        rules.put("!=", Arrays.asList("0"));
        rules.put(">=", Arrays.asList("0", "1"));
        rules.put("<=", Arrays.asList("0"));
        return rules;
    }

    @Override
    public Object visit(ASTPrimarySuffix node, Object data) {
        if (node.getImage() != null && node.getImage().endsWith("size")) {
            ASTClassOrInterfaceType type = this.getTypeOfPrimaryPrefix(node);
            if (type == null) {
                type = this.getTypeOfMethodCall(node);
            }
            if (type != null && CollectionUtil.isCollectionType(type.getType(), (boolean)true)) {
                Node expr = node.jjtGetParent().jjtGetParent();
                this.checkNodeAndReport(data, (Node)node, expr);
            }
        }
        return data;
    }

    private ASTClassOrInterfaceType getTypeOfMethodCall(ASTPrimarySuffix node) {
        ASTClassOrInterfaceType type = null;
        ASTName methodName = (ASTName)((ASTPrimaryPrefix)node.jjtGetParent().getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class);
        if (methodName != null) {
            ClassScope classScope = (ClassScope)node.getScope().getEnclosingScope(ClassScope.class);
            Map<MethodNameDeclaration, List<NameOccurrence>> methods = classScope.getMethodDeclarations();
            for (Map.Entry<MethodNameDeclaration, List<NameOccurrence>> e : methods.entrySet()) {
                if (!e.getKey().getName().equals(methodName.getImage())) continue;
                type = (ASTClassOrInterfaceType)((ASTResultType)((ASTMethodDeclaration)e.getKey().getNode().getFirstParentOfType(ASTMethodDeclaration.class)).getFirstChildOfType(ASTResultType.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class);
                break;
            }
        }
        return type;
    }

    private ASTClassOrInterfaceType getTypeOfPrimaryPrefix(ASTPrimarySuffix node) {
        return (ASTClassOrInterfaceType)((ASTPrimaryPrefix)node.jjtGetParent().getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class);
    }
}

