/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.UnaryFunction;

public class DeclarationFinderFunction
implements UnaryFunction<NameDeclaration> {
    private NameOccurrence occurrence;
    private NameDeclaration decl;

    public DeclarationFinderFunction(NameOccurrence occurrence) {
        this.occurrence = occurrence;
    }

    public void applyTo(NameDeclaration nameDeclaration) {
        if (this.isDeclaredBefore(nameDeclaration) && this.isSameName(nameDeclaration)) {
            this.decl = nameDeclaration;
        }
    }

    private boolean isDeclaredBefore(NameDeclaration nameDeclaration) {
        if (nameDeclaration.getNode() != null && this.occurrence.getLocation() != null) {
            return nameDeclaration.getNode().getBeginLine() <= this.occurrence.getLocation().getBeginLine();
        }
        return true;
    }

    private boolean isSameName(NameDeclaration nameDeclaration) {
        return this.occurrence.getImage().equals(nameDeclaration.getName());
    }

    public NameDeclaration getDecl() {
        return this.decl;
    }
}

