/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.unusedcode;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class UnusedPrivateFieldRule
extends AbstractJavaRule {
    private boolean lombokImported = false;
    private static final String LOMBOK_PACKAGE = "lombok";
    private static final Set<String> LOMBOK_ANNOTATIONS = new HashSet<String>();

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.lombokImported = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName name = (ASTName)node.getFirstChildOfType(ASTName.class);
        if (!this.lombokImported && name != null && name.getImage() != null & name.getImage().startsWith(LOMBOK_PACKAGE)) {
            this.lombokImported = true;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        boolean classHasLombok = this.hasLombokAnnotation(node);
        Map vars = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : vars.entrySet()) {
            VariableNameDeclaration decl = (VariableNameDeclaration)entry.getKey();
            AccessNode accessNodeParent = decl.getAccessNodeParent();
            if (!accessNodeParent.isPrivate() || this.isOK(decl.getImage()) || classHasLombok || this.hasLombokAnnotation(accessNodeParent) || this.actuallyUsed((List)entry.getValue()) || this.usedInOuterClass(node, (NameDeclaration)decl) || this.usedInOuterEnum(node, (NameDeclaration)decl)) continue;
            this.addViolation(data, (Node)decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private boolean hasLombokAnnotation(Node node) {
        boolean result = false;
        Node parent = node.jjtGetParent();
        List annotations = parent.findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            String shortName;
            ASTName name = (ASTName)annotation.getFirstDescendantOfType(ASTName.class);
            if (name == null) continue;
            String annotationName = name.getImage();
            if (this.lombokImported) {
                if (!LOMBOK_ANNOTATIONS.contains(annotationName)) continue;
                result = true;
                continue;
            }
            if (!annotationName.startsWith("lombok.") || !LOMBOK_ANNOTATIONS.contains(shortName = annotationName.substring(LOMBOK_PACKAGE.length() + 1))) continue;
            result = true;
        }
        return result;
    }

    private boolean usedInOuterEnum(ASTClassOrInterfaceDeclaration node, NameDeclaration decl) {
        List outerEnums = node.getParentsOfType(ASTEnumDeclaration.class);
        for (ASTEnumDeclaration outerEnum : outerEnums) {
            ASTEnumBody enumBody = (ASTEnumBody)outerEnum.getFirstChildOfType(ASTEnumBody.class);
            if (!this.usedInOuter(decl, enumBody)) continue;
            return true;
        }
        return false;
    }

    private boolean usedInOuterClass(ASTClassOrInterfaceDeclaration node, NameDeclaration decl) {
        List outerClasses = node.getParentsOfType(ASTClassOrInterfaceDeclaration.class);
        for (ASTClassOrInterfaceDeclaration outerClass : outerClasses) {
            ASTClassOrInterfaceBody classOrInterfaceBody = (ASTClassOrInterfaceBody)outerClass.getFirstChildOfType(ASTClassOrInterfaceBody.class);
            if (!this.usedInOuter(decl, classOrInterfaceBody)) continue;
            return true;
        }
        return false;
    }

    private boolean usedInOuter(NameDeclaration decl, JavaNode body) {
        List classOrInterfaceBodyDeclarations = body.findChildrenOfType(ASTClassOrInterfaceBodyDeclaration.class);
        List enumConstants = body.findChildrenOfType(ASTEnumConstant.class);
        ArrayList nodes = new ArrayList();
        nodes.addAll(classOrInterfaceBodyDeclarations);
        nodes.addAll(enumConstants);
        for (JavaNode node : nodes) {
            List primarySuffixes = node.findDescendantsOfType(ASTPrimarySuffix.class);
            for (ASTPrimarySuffix primarySuffix : primarySuffixes) {
                if (!decl.getImage().equals(primarySuffix.getImage())) continue;
                return true;
            }
            List primaryPrefixes = node.findDescendantsOfType(ASTPrimaryPrefix.class);
            for (ASTPrimaryPrefix primaryPrefix : primaryPrefixes) {
                ASTName name = (ASTName)primaryPrefix.getFirstDescendantOfType(ASTName.class);
                if (name == null) continue;
                for (String id : name.getImage().split("\\.")) {
                    if (!id.equals(decl.getImage())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean actuallyUsed(List<NameOccurrence> usages) {
        for (NameOccurrence nameOccurrence : usages) {
            JavaNameOccurrence jNameOccurrence = (JavaNameOccurrence)nameOccurrence;
            if (jNameOccurrence.isOnLeftHandSide()) continue;
            return true;
        }
        return false;
    }

    private boolean isOK(String image) {
        return image.equals("serialVersionUID") || image.equals("serialPersistentFields") || image.equals("IDENT");
    }

    static {
        LOMBOK_ANNOTATIONS.add("Data");
        LOMBOK_ANNOTATIONS.add("Getter");
        LOMBOK_ANNOTATIONS.add("Setter");
        LOMBOK_ANNOTATIONS.add("Value");
        LOMBOK_ANNOTATIONS.add("RequiredArgsConstructor");
        LOMBOK_ANNOTATIONS.add("AllArgsConstructor");
        LOMBOK_ANNOTATIONS.add("Builder");
    }
}

