/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.unusedcode;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class UnusedPrivateMethodRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map<MethodNameDeclaration, List<NameOccurrence>> methods = ((ClassScope)node.getScope().getEnclosingScope(ClassScope.class)).getMethodDeclarations();
        for (MethodNameDeclaration mnd : this.findUnique(methods)) {
            List<NameOccurrence> occs = methods.get((Object)mnd);
            if (!this.privateAndNotExcluded((NameDeclaration)mnd)) continue;
            if (occs.isEmpty()) {
                this.addViolation(data, (Node)mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
                continue;
            }
            if (!this.calledFromOutsideItself(occs, (NameDeclaration)mnd)) continue;
            this.addViolation(data, (Node)mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
        }
        return data;
    }

    private Set<MethodNameDeclaration> findUnique(Map<MethodNameDeclaration, List<NameOccurrence>> methods) {
        HashSet<MethodNameDeclaration> unique = new HashSet<MethodNameDeclaration>();
        HashSet<String> sigs = new HashSet<String>();
        for (MethodNameDeclaration mnd : methods.keySet()) {
            String sig = mnd.getImage() + mnd.getParameterCount() + mnd.isVarargs();
            if (!sigs.contains(sig)) {
                unique.add(mnd);
            }
            sigs.add(sig);
        }
        return unique;
    }

    private boolean calledFromOutsideItself(List<NameOccurrence> occs, NameDeclaration mnd) {
        int callsFromOutsideMethod = 0;
        for (NameOccurrence occ : occs) {
            ScopedNode occNode = occ.getLocation();
            ASTConstructorDeclaration enclosingConstructor = (ASTConstructorDeclaration)occNode.getFirstParentOfType(ASTConstructorDeclaration.class);
            if (enclosingConstructor != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTInitializer enclosingInitializer = (ASTInitializer)occNode.getFirstParentOfType(ASTInitializer.class);
            if (enclosingInitializer != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTMethodDeclaration enclosingMethod = (ASTMethodDeclaration)occNode.getFirstParentOfType(ASTMethodDeclaration.class);
            if (enclosingMethod != null && mnd.getNode().jjtGetParent().equals(enclosingMethod)) continue;
            ++callsFromOutsideMethod;
        }
        return callsFromOutsideMethod == 0;
    }

    private boolean privateAndNotExcluded(NameDeclaration mnd) {
        ASTMethodDeclarator node = (ASTMethodDeclarator)mnd.getNode();
        return ((AccessNode)node.jjtGetParent()).isPrivate() && !node.hasImageEqualTo("readObject") && !node.hasImageEqualTo("writeObject") && !node.hasImageEqualTo("readResolve") && !node.hasImageEqualTo("writeReplace");
    }
}

