/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.strings;

import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;

public class ConsecutiveAppendsShouldReuseRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTBlockStatement node, Object data) {
        String nextVariable;
        ASTBlockStatement nextSibling;
        String variable = this.getVariableAppended(node);
        if (variable != null && (nextSibling = this.getNextBlockStatementSibling((Node)node)) != null && (nextVariable = this.getVariableAppended(nextSibling)) != null && nextVariable.equals(variable)) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    private ASTBlockStatement getNextBlockStatementSibling(Node node) {
        Node nextSibling;
        Node parent = node.jjtGetParent();
        int childIndex = -1;
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            if (parent.jjtGetChild(i) != node) continue;
            childIndex = i;
            break;
        }
        if (childIndex + 1 < parent.jjtGetNumChildren() && (nextSibling = parent.jjtGetChild(childIndex + 1)) instanceof ASTBlockStatement) {
            return (ASTBlockStatement)nextSibling;
        }
        return null;
    }

    private String getVariableAppended(ASTBlockStatement node) {
        String variable;
        String image;
        ASTName name;
        ASTStatementExpression stmtExp;
        ASTPrimaryPrefix primaryPrefix;
        ASTStatement statement;
        if (this.isFirstChild((Node)node, ASTStatement.class) && this.isFirstChild((Node)(statement = (ASTStatement)node.jjtGetChild(0)), ASTStatementExpression.class) && (primaryPrefix = (ASTPrimaryPrefix)(stmtExp = (ASTStatementExpression)statement.jjtGetChild(0)).getFirstDescendantOfType(ASTPrimaryPrefix.class)) != null && (name = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class)) != null && (image = name.getImage()).endsWith(".append") && this.isAStringBuilderBuffer(primaryPrefix, variable = image.substring(0, image.indexOf(46)))) {
            return variable;
        }
        return null;
    }

    private boolean isAStringBuilderBuffer(ASTPrimaryPrefix prefix, String name) {
        Map declarations = prefix.getScope().getDeclarations(VariableNameDeclaration.class);
        for (VariableNameDeclaration decl : declarations.keySet()) {
            if (!decl.getName().equals(name) || !TypeHelper.isEither(decl, StringBuilder.class, StringBuffer.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isFirstChild(Node node, Class<?> clazz) {
        return node.jjtGetNumChildren() == 1 && clazz.isAssignableFrom(node.jjtGetChild(0).getClass());
    }
}

