/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;

public class SimpleTypedNameDeclaration
implements TypedNameDeclaration {
    private final String typeImage;
    private final Class<?> type;
    private static Set<String> primitiveTypes = new HashSet<String>();

    public SimpleTypedNameDeclaration(String typeImage, Class<?> type) {
        this.typeImage = typeImage;
        this.type = type;
    }

    @Override
    public String getTypeImage() {
        return this.typeImage;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "SimpleType:" + this.type + "/" + this.typeImage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.typeImage == null ? 0 : this.typeImage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTypedNameDeclaration other = (SimpleTypedNameDeclaration)obj;
        if (this.type == null && other.type != null) {
            return false;
        }
        if (this.type != null && this.type.equals(other.type)) {
            return true;
        }
        if (this.type != null && other.type != null && (this.type.isAssignableFrom(other.type) || other.type.isAssignableFrom(this.type))) {
            return true;
        }
        if (this.typeImage == null) {
            if (other.typeImage != null) {
                return false;
            }
        } else if (!this.typeImage.equals(other.typeImage)) {
            if (other.typeImage != null) {
                String lcType = this.typeImage.toLowerCase();
                String otherLcType = other.typeImage.toLowerCase();
                if (primitiveTypes.contains(lcType) && primitiveTypes.contains(otherLcType)) {
                    if (lcType.equals(otherLcType)) {
                        return true;
                    }
                    if ((lcType.equals("char") || lcType.equals("character")) && (otherLcType.equals("char") || otherLcType.equals("character"))) {
                        return true;
                    }
                    if ((lcType.equals("int") || lcType.equals("integer")) && (otherLcType.equals("int") || otherLcType.equals("integer") || otherLcType.equals("short") || otherLcType.equals("char") || otherLcType.equals("character") || otherLcType.equals("byte"))) {
                        return true;
                    }
                    if (lcType.equals("double") && (otherLcType.equals("float") || otherLcType.equals("int") || otherLcType.equals("integer") || otherLcType.equals("long"))) {
                        return true;
                    }
                    if (lcType.equals("float") && (otherLcType.equals("int") || otherLcType.equals("integer") || otherLcType.equals("long"))) {
                        return true;
                    }
                    if (lcType.equals("long") && (otherLcType.equals("int") || otherLcType.equals("integer") || otherLcType.equals("char") || otherLcType.equals("character"))) {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    static {
        primitiveTypes.add("float");
        primitiveTypes.add("double");
        primitiveTypes.add("int");
        primitiveTypes.add("integer");
        primitiveTypes.add("long");
        primitiveTypes.add("byte");
        primitiveTypes.add("short");
        primitiveTypes.add("boolean");
        primitiveTypes.add("char");
        primitiveTypes.add("character");
    }
}

