/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ImmutableFieldRule
extends AbstractJavaRule {
    private static final int MUTABLE = 0;
    private static final int IMMUTABLE = 1;
    private static final int CHECKDECL = 2;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map vars = node.getScope().getDeclarations(VariableNameDeclaration.class);
        List<ASTConstructorDeclaration> constructors = this.findAllConstructors(node);
        for (Map.Entry entry : vars.entrySet()) {
            int result;
            VariableNameDeclaration field = (VariableNameDeclaration)entry.getKey();
            AccessNode accessNodeParent = field.getAccessNodeParent();
            if (accessNodeParent.isStatic() || !accessNodeParent.isPrivate() || accessNodeParent.isFinal() || accessNodeParent.isVolatile() || (result = this.initializedInConstructor((List)entry.getValue(), new HashSet<ASTConstructorDeclaration>(constructors))) == 0 || result != 1 && (result != 2 || !this.initializedWhenDeclared(field))) continue;
            this.addViolation(data, (Node)field.getNode(), field.getImage());
        }
        return super.visit(node, data);
    }

    private boolean initializedWhenDeclared(VariableNameDeclaration field) {
        return field.getAccessNodeParent().hasDescendantOfType(ASTVariableInitializer.class);
    }

    private int initializedInConstructor(List<NameOccurrence> usages, Set<ASTConstructorDeclaration> allConstructors) {
        int result = 0;
        int methodInitCount = 0;
        HashSet<ASTConstructorDeclaration> consSet = new HashSet<ASTConstructorDeclaration>();
        for (NameOccurrence occ : usages) {
            JavaNameOccurrence jocc = (JavaNameOccurrence)occ;
            if (!jocc.isOnLeftHandSide() && !jocc.isSelfAssignment()) continue;
            JavaNode node = jocc.getLocation();
            ASTConstructorDeclaration constructor = (ASTConstructorDeclaration)node.getFirstParentOfType(ASTConstructorDeclaration.class);
            if (constructor != null) {
                if (this.inLoopOrTry((Node)node)) continue;
                if (node.getFirstParentOfType(ASTIfStatement.class) != null) {
                    ++methodInitCount;
                }
                if (this.inAnonymousInnerClass((Node)node)) {
                    ++methodInitCount;
                    continue;
                }
                consSet.add(constructor);
                continue;
            }
            if (node.getFirstParentOfType(ASTMethodDeclaration.class) == null) continue;
            ++methodInitCount;
        }
        if (usages.isEmpty() || methodInitCount == 0 && consSet.isEmpty()) {
            result = 2;
        } else {
            allConstructors.removeAll(consSet);
            if (allConstructors.isEmpty() && methodInitCount == 0) {
                result = 1;
            }
        }
        return result;
    }

    private boolean inLoopOrTry(Node node) {
        return node.getFirstParentOfType(ASTTryStatement.class) != null || node.getFirstParentOfType(ASTForStatement.class) != null || node.getFirstParentOfType(ASTWhileStatement.class) != null || node.getFirstParentOfType(ASTDoStatement.class) != null;
    }

    private boolean inAnonymousInnerClass(Node node) {
        ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        return parent != null && parent.isAnonymousInnerClass();
    }

    private List<ASTConstructorDeclaration> findAllConstructors(ASTClassOrInterfaceDeclaration node) {
        ArrayList<ASTConstructorDeclaration> cons = new ArrayList<ASTConstructorDeclaration>();
        ((ASTClassOrInterfaceBody)node.getFirstChildOfType(ASTClassOrInterfaceBody.class)).findDescendantsOfType(ASTConstructorDeclaration.class, cons, false);
        return cons;
    }
}

