/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStream;
import groovyjarjarantlr.TokenStreamException;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.antlr.parser.GroovyLexer;

public class GroovyTokenizer
implements Tokenizer {
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        GroovyLexer lexer = new GroovyLexer(IOUtils.toInputStream((String)buffer.toString()));
        TokenStream tokenStream = lexer.plumb();
        try {
            Token token = tokenStream.nextToken();
            while (token.getType() != 1) {
                TokenEntry tokenEntry = new TokenEntry(token.getText(), sourceCode.getFileName(), token.getLine());
                tokenEntries.add(tokenEntry);
                token = tokenStream.nextToken();
            }
        }
        catch (TokenStreamException err) {
            throw new TokenMgrError("Lexical error in file " + sourceCode.getFileName() + " at line " + lexer.getLine() + ", column " + lexer.getColumn() + ".  Encountered: " + err.getMessage(), 0);
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }
}

