/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.impl.AntlrTokenizer;
import net.sourceforge.pmd.cpd.token.AntlrTokenFilter;
import net.sourceforge.pmd.lang.ast.impl.antlr4.AntlrToken;
import net.sourceforge.pmd.lang.ast.impl.antlr4.AntlrTokenManager;
import net.sourceforge.pmd.lang.dart.ast.DartLexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;

public class DartTokenizer
extends AntlrTokenizer {
    protected Lexer getLexerForSource(CharStream charStream) {
        return new DartLexer(charStream);
    }

    protected AntlrTokenFilter getTokenFilter(AntlrTokenManager tokenManager) {
        return new DartTokenFilter(tokenManager);
    }

    private static class DartTokenFilter
    extends AntlrTokenFilter {
        private boolean discardingLibraryAndImport = false;
        private boolean discardingNL = false;
        private boolean discardingSemicolon = false;

        DartTokenFilter(AntlrTokenManager tokenManager) {
            super(tokenManager);
        }

        protected void analyzeToken(AntlrToken currentToken) {
            this.skipLibraryAndImport(currentToken);
            this.skipNewLines(currentToken);
            this.skipSemicolons(currentToken);
        }

        private void skipLibraryAndImport(AntlrToken currentToken) {
            int type = currentToken.getKind();
            if (type == 120 || type == 118) {
                this.discardingLibraryAndImport = true;
            } else if (this.discardingLibraryAndImport && (type == 101 || type == 106)) {
                this.discardingLibraryAndImport = false;
            }
        }

        private void skipNewLines(AntlrToken currentToken) {
            this.discardingNL = currentToken.getKind() == 106;
        }

        private void skipSemicolons(AntlrToken currentToken) {
            this.discardingSemicolon = currentToken.getKind() == 101;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingLibraryAndImport || this.discardingNL || this.discardingSemicolon;
        }
    }
}

