/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.Properties;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class CsTokenizer
implements net.sourceforge.pmd.cpd.Tokenizer {
    private boolean ignoreUsings = false;

    public void setProperties(Properties properties) {
        if (properties.containsKey("ignore_usings")) {
            this.ignoreUsings = Boolean.parseBoolean(properties.getProperty("ignore_usings", "false"));
        }
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        Tokenizer tokenizer = new Tokenizer(sourceCode.getCodeBuffer().toString());
        Token token = tokenizer.getNextToken();
        while (!token.equals(Token.EOF)) {
            Token lookAhead = tokenizer.getNextToken();
            if (this.ignoreUsings && "using".equals(token.image) && !"(".equals(lookAhead.image)) {
                String randomTokenText = RandomStringUtils.randomAlphanumeric((int)20);
                token = new Token(randomTokenText, token.lineNumber);
                while (!";".equals(lookAhead.image) && !lookAhead.equals(Token.EOF)) {
                    lookAhead = tokenizer.getNextToken();
                }
            }
            if (!";".equals(token.image)) {
                tokenEntries.add(new TokenEntry(token.image, sourceCode.getFileName(), token.lineNumber));
            }
            token = lookAhead;
        }
        tokenEntries.add(TokenEntry.getEOF());
        IOUtils.closeQuietly((Closeable)tokenizer);
    }

    public void setIgnoreUsings(boolean ignoreUsings) {
        this.ignoreUsings = ignoreUsings;
    }

    private static class Token {
        public static final Token EOF = new Token("EOF", -1);
        public final String image;
        public final int lineNumber;

        public Token(String image, int lineNumber) {
            this.image = image;
            this.lineNumber = lineNumber;
        }
    }

    private static class Tokenizer
    implements Closeable {
        private boolean endOfFile = false;
        private int line = 1;
        private final PushbackReader reader;

        public Tokenizer(String sourceCode) {
            this.reader = new PushbackReader(new BufferedReader(new CharArrayReader(sourceCode.toCharArray())));
        }

        public Token getNextToken() {
            if (this.endOfFile) {
                return Token.EOF;
            }
            try {
                int ic = this.reader.read();
                block17: while (ic != -1) {
                    StringBuilder b;
                    char c = (char)ic;
                    switch (c) {
                        case '\n': {
                            ++this.line;
                            ic = this.reader.read();
                            continue block17;
                        }
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            ic = this.reader.read();
                            continue block17;
                        }
                        case ';': {
                            return new Token(";", this.line);
                        }
                        case '<': 
                        case '>': {
                            ic = this.reader.read();
                            if (ic == 61) {
                                return new Token(c + "=", this.line);
                            }
                            if (ic == c) {
                                ic = this.reader.read();
                                if (ic == 61) {
                                    return new Token(c + c + "=", this.line);
                                }
                                this.reader.unread(ic);
                                return new Token(String.valueOf(c) + c, this.line);
                            }
                            this.reader.unread(ic);
                            return new Token(String.valueOf(c), this.line);
                        }
                        case '&': 
                        case '+': 
                        case '-': 
                        case '=': 
                        case '|': {
                            ic = this.reader.read();
                            if (ic == 61 || ic == c) {
                                return new Token(c + String.valueOf((char)ic), this.line);
                            }
                            this.reader.unread(ic);
                            return new Token(String.valueOf(c), this.line);
                        }
                        case '!': 
                        case '%': 
                        case '*': 
                        case '^': 
                        case '~': {
                            ic = this.reader.read();
                            if (ic == 61) {
                                return new Token(c + "=", this.line);
                            }
                            this.reader.unread(ic);
                            return new Token(String.valueOf(c), this.line);
                        }
                        case '\"': 
                        case '\'': {
                            int beginLine = this.line;
                            b = new StringBuilder();
                            b.append(c);
                            while ((ic = this.reader.read()) != c && ic != -1) {
                                b.append((char)ic);
                                if (ic == 92) {
                                    int next = this.reader.read();
                                    if (next == -1) continue;
                                    b.append((char)next);
                                    if (next != 10) continue;
                                    ++this.line;
                                    continue;
                                }
                                if (ic != 10) continue;
                                ++this.line;
                            }
                            if (ic != -1) {
                                b.append((char)ic);
                            }
                            return new Token(b.toString(), beginLine);
                        }
                        case '/': {
                            ic = this.reader.read();
                            c = (char)ic;
                            switch (c) {
                                case '*': {
                                    int state = 1;
                                    b = new StringBuilder();
                                    b.append("/*");
                                    while ((ic = this.reader.read()) != -1) {
                                        c = (char)ic;
                                        b.append(c);
                                        if (c == '\n') {
                                            ++this.line;
                                        }
                                        if (state == 1) {
                                            if (c != '*') continue;
                                            state = 2;
                                            continue;
                                        }
                                        if (c == '/') {
                                            ic = this.reader.read();
                                            continue block17;
                                        }
                                        if (c == '*') continue;
                                        state = 1;
                                    }
                                    continue block17;
                                }
                                case '/': {
                                    b = new StringBuilder();
                                    b.append("//");
                                    while ((ic = this.reader.read()) != 10 && ic != -1) {
                                        b.append((char)ic);
                                    }
                                    continue block17;
                                }
                                case '=': {
                                    return new Token("/=", this.line);
                                }
                            }
                            this.reader.unread(ic);
                            return new Token("/", this.line);
                        }
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        b = new StringBuilder();
                        do {
                            b.append(c);
                        } while (Character.isJavaIdentifierPart(c = (char)(ic = this.reader.read())));
                        this.reader.unread(ic);
                        return new Token(b.toString(), this.line);
                    }
                    if (Character.isDigit(c) || c == '.') {
                        b = new StringBuilder();
                        do {
                            b.append(c);
                            if (c != 'e' && c != 'E') continue;
                            ic = this.reader.read();
                            c = (char)ic;
                            if ("1234567890-".indexOf(c) == -1) break;
                            b.append(c);
                        } while ("1234567890.iIlLfFdDsSuUeExX".indexOf(c = (char)(ic = this.reader.read())) != -1);
                        this.reader.unread(ic);
                        return new Token(b.toString(), this.line);
                    }
                    return new Token(String.valueOf(c), this.line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.endOfFile = true;
            return Token.EOF;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

