/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.internal.DefaultRulechainVisitor;
import net.sourceforge.pmd.util.CollectionUtil;

public abstract class BaseLanguageModule
implements Language {
    protected String name;
    protected String shortName;
    protected String terseName;
    protected Class<?> ruleChainVisitorClass;
    protected List<String> extensions;
    private final List<LanguageVersion> distinctVersions = new ArrayList<LanguageVersion>();
    protected Map<String, LanguageVersion> versions;
    protected LanguageVersion defaultVersion;

    @Deprecated
    public BaseLanguageModule(String name, String shortName, String terseName, Class<?> ruleChainVisitorClass, String ... extensions) {
        this.name = name;
        this.shortName = shortName;
        this.terseName = terseName;
        this.ruleChainVisitorClass = ruleChainVisitorClass;
        this.extensions = Arrays.asList(extensions);
    }

    public BaseLanguageModule(String name, String shortName, String terseName, String firstExtension, String ... otherExtensions) {
        this.name = name;
        this.shortName = shortName;
        this.terseName = terseName;
        this.ruleChainVisitorClass = DefaultRulechainVisitor.class;
        this.extensions = CollectionUtil.listOf(firstExtension, otherExtensions);
    }

    private void addVersion(String version, LanguageVersionHandler languageVersionHandler, boolean isDefault, String ... versionAliases) {
        if (this.versions == null) {
            this.versions = new HashMap<String, LanguageVersion>();
        }
        LanguageVersion languageVersion = new LanguageVersion(this, version, languageVersionHandler);
        this.distinctVersions.add(languageVersion);
        this.checkNotPresent(version);
        this.versions.put(version, languageVersion);
        for (String alias : versionAliases) {
            this.checkNotPresent(alias);
            this.versions.put(alias, languageVersion);
        }
        if (isDefault) {
            if (this.defaultVersion != null) {
                throw new IllegalStateException("Default version already set to " + this.defaultVersion + ", cannot set it to " + languageVersion);
            }
            this.defaultVersion = languageVersion;
        }
    }

    private void checkNotPresent(String alias) {
        if (this.versions.containsKey(alias)) {
            throw new IllegalArgumentException("Version key '" + alias + "' is duplicated");
        }
    }

    protected void addVersion(String version, LanguageVersionHandler languageVersionHandler, String ... versionAliases) {
        this.addVersion(version, languageVersionHandler, false, versionAliases);
    }

    protected void addDefaultVersion(String version, LanguageVersionHandler languageVersionHandler, String ... versionAliases) {
        this.addVersion(version, languageVersionHandler, true, versionAliases);
    }

    @Deprecated
    protected void addVersion(String version, LanguageVersionHandler languageVersionHandler, boolean isDefault) {
        this.addVersion(version, languageVersionHandler, isDefault, new String[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName != null ? this.shortName : this.name;
    }

    @Override
    public String getTerseName() {
        return this.terseName;
    }

    @Override
    public Class<?> getRuleChainVisitorClass() {
        return this.ruleChainVisitorClass;
    }

    @Override
    public List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    @Override
    public boolean hasExtension(String extension) {
        return this.extensions != null && this.extensions.contains(extension);
    }

    @Override
    public List<LanguageVersion> getVersions() {
        return new ArrayList<LanguageVersion>(this.distinctVersions);
    }

    @Override
    public boolean hasVersion(String version) {
        return this.versions != null && this.versions.containsKey(version);
    }

    @Override
    public LanguageVersion getVersion(String versionName) {
        if (this.versions != null) {
            return this.versions.get(versionName);
        }
        return null;
    }

    @Override
    public LanguageVersion getDefaultVersion() {
        assert (this.defaultVersion != null) : "Null default version for language " + this;
        return this.defaultVersion;
    }

    public String toString() {
        return "LanguageModule:" + this.name + '(' + this.getClass().getSimpleName() + ')';
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseLanguageModule)) {
            return false;
        }
        BaseLanguageModule other = (BaseLanguageModule)obj;
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(Language o) {
        return this.getName().compareTo(o.getName());
    }
}

