/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.StringTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;

public class AnyTokenizer
implements Tokenizer {
    public static final String TOKENS = " \t!#$%^&*(){}-=+<>/\\`~;:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder sb = sourceCode.getCodeBuffer();
        try (BufferedReader reader = new BufferedReader(new CharArrayReader(sb.toString().toCharArray()));){
            int lineNumber = 1;
            int colNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, TOKENS, true);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    int endCol = colNumber + token.length() - 1;
                    if (!" ".equals(token) && !"\t".equals(token)) {
                        tokenEntries.add(new TokenEntry(token, sourceCode.getFileName(), lineNumber, colNumber, endCol));
                    }
                    colNumber = endCol + 1;
                }
                line = reader.readLine();
                ++lineNumber;
            }
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }
}

