/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;

public abstract class AbstractTokenizer
implements Tokenizer {
    protected List<String> stringToken;
    protected List<String> ignorableCharacter;
    protected List<String> ignorableStmt;
    protected char oneLineCommentChar = (char)35;
    private List<String> code;
    private int lineNumber = 0;
    private String currentLine;
    private int tokBeginLine;
    private int tokBeginCol;
    protected boolean spanMultipleLinesString = true;
    protected Character spanMultipleLinesLineContinuationCharacter = null;
    private boolean downcaseString = true;

    @Override
    public void tokenize(SourceCode tokens, Tokens tokenEntries) {
        this.code = tokens.getCode();
        this.lineNumber = 0;
        while (this.lineNumber < this.code.size()) {
            this.currentLine = this.code.get(this.lineNumber);
            int loc = 0;
            while (loc < this.currentLine.length()) {
                StringBuilder token = new StringBuilder();
                loc = this.getTokenFromLine(token, loc);
                if (token.length() <= 0 || this.isIgnorableString(token.toString())) continue;
                String image = this.downcaseString ? token.toString().toLowerCase(Locale.ROOT) : token.toString();
                tokenEntries.add(new TokenEntry(image, tokens.getFileName(), this.tokBeginLine + 1, this.tokBeginCol + 1, loc));
            }
            ++this.lineNumber;
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    private int getTokenFromLine(StringBuilder token, int loc) {
        this.tokBeginLine = this.lineNumber;
        this.tokBeginCol = loc;
        int j = loc;
        while (j < this.currentLine.length()) {
            char tok = this.currentLine.charAt(j);
            if (!Character.isWhitespace(tok) && !this.ignoreCharacter(tok)) {
                if (this.isComment(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.getCommentToken(token, loc);
                }
                if (this.isString(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.parseString(token, j, tok);
                }
                token.append(tok);
            } else {
                if (token.length() > 0) {
                    return j;
                }
                ++this.tokBeginCol;
            }
            loc = j++;
        }
        return loc + 1;
    }

    private int parseString(StringBuilder token, int loc, char stringDelimiter) {
        boolean escaped = false;
        boolean done = false;
        while (loc < this.currentLine.length() && !done) {
            char tok = this.currentLine.charAt(loc);
            if (escaped && tok == stringDelimiter) {
                escaped = false;
            } else if (tok == stringDelimiter && token.length() > 0) {
                done = true;
            } else {
                escaped = tok == '\\';
            }
            token.append(tok);
            ++loc;
        }
        if (!done && this.spanMultipleLinesString && this.lineNumber < this.code.size() - 1) {
            if (this.spanMultipleLinesLineContinuationCharacter != null && token.length() > 0 && token.charAt(token.length() - 1) == this.spanMultipleLinesLineContinuationCharacter.charValue()) {
                token.setLength(token.length() - 1);
            }
            this.currentLine = this.code.get(++this.lineNumber);
            loc = this.parseString(token, 0, stringDelimiter);
        }
        return loc;
    }

    private boolean ignoreCharacter(char tok) {
        return this.ignorableCharacter.contains(String.valueOf(tok));
    }

    private boolean isString(char tok) {
        return this.stringToken.contains(String.valueOf(tok));
    }

    private boolean isComment(char tok) {
        return tok == this.oneLineCommentChar;
    }

    private int getCommentToken(StringBuilder token, int loc) {
        while (loc < this.currentLine.length()) {
            token.append(this.currentLine.charAt(loc++));
        }
        return loc;
    }

    private boolean isIgnorableString(String token) {
        return this.ignorableStmt.contains(token);
    }
}

