/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.util.ResourceLoader;

public final class RulesetsFactoryUtils {
    private static final Logger LOG = Logger.getLogger(RulesetsFactoryUtils.class.getName());

    private RulesetsFactoryUtils() {
    }

    @Deprecated
    @InternalApi
    public static RuleSets getRuleSets(String rulesets, RuleSetFactory factory) {
        RuleSets ruleSets = null;
        try {
            ruleSets = factory.createRuleSets(rulesets);
            RulesetsFactoryUtils.printRuleNamesInDebug(ruleSets);
            if (ruleSets.ruleCount() == 0) {
                String msg = "No rules found. Maybe you mispelled a rule name? (" + rulesets + ')';
                LOG.log(Level.SEVERE, msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (RuleSetNotFoundException rsnfe) {
            LOG.log(Level.SEVERE, "Ruleset not found", rsnfe);
            throw new IllegalArgumentException(rsnfe);
        }
        return ruleSets;
    }

    @Deprecated
    @InternalApi
    public static RuleSets getRuleSetsWithBenchmark(String rulesets, RuleSetFactory factory) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.LOAD_RULES);){
            RuleSets ruleSets = RulesetsFactoryUtils.getRuleSets(rulesets, factory);
            return ruleSets;
        }
    }

    @Deprecated
    @InternalApi
    public static RuleSetFactory getRulesetFactory(PMDConfiguration configuration, ResourceLoader resourceLoader) {
        return new RuleSetFactory(resourceLoader, configuration.getMinimumPriority(), true, configuration.isRuleSetFactoryCompatibilityEnabled());
    }

    public static RuleSetFactory createFactory(PMDConfiguration configuration) {
        return RulesetsFactoryUtils.createFactory(configuration, RulesetsFactoryUtils.class.getClassLoader());
    }

    public static RuleSetFactory defaultFactory() {
        return new RuleSetFactory();
    }

    public static RuleSetFactory createFactory(PMDConfiguration configuration, ClassLoader classLoader) {
        return RulesetsFactoryUtils.createFactory(classLoader, configuration.getMinimumPriority(), true, configuration.isRuleSetFactoryCompatibilityEnabled());
    }

    public static RuleSetFactory createFactory(ClassLoader classLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        return new RuleSetFactory(new ResourceLoader(classLoader), minimumPriority, warnDeprecated, enableCompatibility);
    }

    public static RuleSetFactory createFactory(RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        return new RuleSetFactory(new ResourceLoader(), minimumPriority, warnDeprecated, enableCompatibility);
    }

    private static void printRuleNamesInDebug(RuleSets rulesets) {
        if (LOG.isLoggable(Level.FINER)) {
            for (Rule r : rulesets.getAllRules()) {
                LOG.finer("Loaded rule " + r.getName());
            }
        }
    }
}

