/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.DataFlowHandler;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.LinkerException;
import net.sourceforge.pmd.lang.dfa.NodeType;
import net.sourceforge.pmd.lang.dfa.SequenceChecker;
import net.sourceforge.pmd.lang.dfa.SequenceException;
import net.sourceforge.pmd.lang.dfa.StackObject;

public class Linker {
    private static final Logger LOGGER = Logger.getLogger(Linker.class.getName());
    private static final String CLASS_NAME = Linker.class.getCanonicalName();
    private static final int MAX_LOOPS = 100;
    private final DataFlowHandler dataFlowHandler;
    private List<StackObject> braceStack;
    private List<StackObject> continueBreakReturnStack;

    public Linker(DataFlowHandler dataFlowHandler, List<StackObject> braceStack, List<StackObject> continueBreakReturnStack) {
        this.dataFlowHandler = dataFlowHandler;
        this.braceStack = braceStack;
        this.continueBreakReturnStack = continueBreakReturnStack;
    }

    public void computePaths() throws LinkerException, SequenceException {
        LOGGER.entering(CLASS_NAME, "computePaths");
        LOGGER.fine("SequenceChecking continueBreakReturnStack elements");
        SequenceChecker sc = new SequenceChecker(this.braceStack);
        int i = 0;
        while (!sc.run() && i < 100) {
            ++i;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("After sc.run - starting Sequence checking loop with firstIndex=" + sc.getFirstIndex() + ", lastIndex " + sc.getLastIndex() + " with this StackList " + Linker.dump("braceStack", this.braceStack));
            }
            if (sc.getFirstIndex() < 0 || sc.getLastIndex() < 0) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Sequence Checker problem: getFirstIndex()==" + sc.getFirstIndex() + ", getLastIndex()==" + sc.getLastIndex());
                }
                throw new SequenceException("computePaths(): return index <  0");
            }
            StackObject firstStackObject = this.braceStack.get(sc.getFirstIndex());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Checking first braceStack element of type==" + (Object)((Object)firstStackObject.getType()));
            }
            switch (firstStackObject.getType()) {
                case IF_EXPR: {
                    LOGGER.finest("IF_EXPR");
                    int x = sc.getLastIndex() - sc.getFirstIndex();
                    if (x == 2) {
                        this.computeIf(sc.getFirstIndex(), sc.getFirstIndex() + 1, sc.getLastIndex());
                        break;
                    }
                    if (x == 1) {
                        this.computeIf(sc.getFirstIndex(), sc.getLastIndex());
                        break;
                    }
                    LOGGER.severe("Error - computePaths 1");
                    break;
                }
                case WHILE_EXPR: {
                    LOGGER.finest("WHILE_EXPR");
                    this.computeWhile(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
                case SWITCH_START: {
                    LOGGER.finest("SWITCH_START");
                    this.computeSwitch(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
                case FOR_INIT: 
                case FOR_EXPR: 
                case FOR_UPDATE: 
                case FOR_BEFORE_FIRST_STATEMENT: {
                    LOGGER.finest("FOR_EXPR");
                    this.computeFor(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
                case DO_BEFORE_FIRST_STATEMENT: {
                    LOGGER.finest("DO_BEFORE_FIRST_STATEMENT");
                    this.computeDo(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Removing braces from Last to first: " + sc.getLastIndex() + " to " + sc.getFirstIndex());
            }
            for (int y = sc.getLastIndex(); y >= sc.getFirstIndex(); --y) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Removing brace : " + y);
                }
                this.braceStack.remove(y);
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Completed Sequence checking loop" + this.braceStack);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "After Sequence checking loop : remaining braces=={0}", Linker.dump("braceStack", this.braceStack));
        }
        LOGGER.fine("Processing continueBreakReturnStack elements");
        while (!this.continueBreakReturnStack.isEmpty()) {
            LOGGER.fine("Starting continueBreakReturnStack processing loop");
            StackObject stackObject = this.continueBreakReturnStack.get(0);
            DataFlowNode node = stackObject.getDataFlowNode();
            switch (stackObject.getType()) {
                case THROW_STATEMENT: 
                case RETURN_STATEMENT: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("CBR: " + (Object)((Object)stackObject.getType()));
                    }
                    node.removePathToChild(node.getChildren().get(0));
                    DataFlowNode lastNode = node.getFlow().get(node.getFlow().size() - 1);
                    node.addPathToChild(lastNode);
                    this.continueBreakReturnStack.remove(0);
                    break;
                }
                case BREAK_STATEMENT: {
                    LOGGER.finest("CBR: BREAK_STATEMENT");
                    DataFlowNode last = this.getNodeToBreakStatement(node);
                    node.removePathToChild(node.getChildren().get(0));
                    node.addPathToChild(last);
                    this.continueBreakReturnStack.remove(0);
                    break;
                }
                case CONTINUE_STATEMENT: {
                    LOGGER.finest("CBR: CONTINUE_STATEMENT");
                    this.continueBreakReturnStack.remove(0);
                    break;
                }
                default: {
                    LOGGER.finest("CBR: default");
                }
            }
            LOGGER.fine("Completed continueBreakReturnStack processing loop");
        }
        LOGGER.exiting(CLASS_NAME, "computePaths");
    }

    private DataFlowNode getNodeToBreakStatement(DataFlowNode node) {
        int index;
        LOGGER.entering(CLASS_NAME, "getNodeToBreakStatement");
        List<DataFlowNode> bList = node.getFlow();
        int findEnds = 1;
        for (index = bList.indexOf(node); index < bList.size() - 2; ++index) {
            DataFlowNode n = bList.get(index);
            if (n.isType(NodeType.DO_EXPR) || n.isType(NodeType.FOR_INIT) || n.isType(NodeType.WHILE_EXPR) || n.isType(NodeType.SWITCH_START)) {
                ++findEnds;
            }
            if (n.isType(NodeType.WHILE_LAST_STATEMENT) || n.isType(NodeType.SWITCH_END) || n.isType(NodeType.FOR_END) || n.isType(NodeType.DO_EXPR)) {
                if (findEnds <= 1) break;
                --findEnds;
            }
            if (!n.isType(NodeType.LABEL_LAST_STATEMENT)) continue;
            Node parentNode = n.getNode().getFirstParentOfType(this.dataFlowHandler.getLabelStatementNodeClass());
            if (parentNode == null) break;
            String label = node.getNode().getImage();
            if (label != null && !label.equals(parentNode.getImage())) continue;
            node.removePathToChild(node.getChildren().get(0));
            DataFlowNode last = bList.get(index + 1);
            node.addPathToChild(last);
            break;
        }
        LOGGER.exiting(CLASS_NAME, "getNodeToBreakSttement");
        return node.getFlow().get(index + 1);
    }

    private void computeDo(int first, int last) {
        LOGGER.entering(CLASS_NAME, "computeDo");
        DataFlowNode doSt = this.braceStack.get(first).getDataFlowNode();
        DataFlowNode doExpr = this.braceStack.get(last).getDataFlowNode();
        DataFlowNode doFirst = doSt.getFlow().get(doSt.getIndex() + 1);
        if (doFirst.getIndex() != doExpr.getIndex()) {
            doExpr.addPathToChild(doFirst);
        }
        LOGGER.exiting(CLASS_NAME, "computeDo");
    }

    private void computeFor(int firstIndex, int lastIndex) {
        LOGGER.entering(CLASS_NAME, "computeFor");
        DataFlowNode fExpr = null;
        DataFlowNode fUpdate = null;
        DataFlowNode fSt = null;
        DataFlowNode fEnd = null;
        boolean isUpdate = false;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            StackObject so = this.braceStack.get(i);
            DataFlowNode node = so.getDataFlowNode();
            if (so.getType() == NodeType.FOR_EXPR) {
                fExpr = node;
                continue;
            }
            if (so.getType() == NodeType.FOR_UPDATE) {
                fUpdate = node;
                isUpdate = true;
                continue;
            }
            if (so.getType() == NodeType.FOR_BEFORE_FIRST_STATEMENT) {
                fSt = node;
                continue;
            }
            if (so.getType() != NodeType.FOR_END) continue;
            fEnd = node;
        }
        DataFlowNode end = fEnd.getFlow().get(fEnd.getIndex() + 1);
        DataFlowNode firstSt = fSt.getChildren().get(0);
        if (isUpdate) {
            if (fSt.getIndex() != fEnd.getIndex()) {
                end.reverseParentPathsTo(fUpdate);
                fExpr.removePathToChild(fUpdate);
                fUpdate.addPathToChild(fExpr);
                fUpdate.removePathToChild(firstSt);
                fExpr.addPathToChild(firstSt);
                fExpr.addPathToChild(end);
            } else {
                fSt.removePathToChild(end);
                fExpr.removePathToChild(fUpdate);
                fUpdate.addPathToChild(fExpr);
                fExpr.addPathToChild(fUpdate);
                fExpr.addPathToChild(end);
            }
        } else if (fSt.getIndex() != fEnd.getIndex()) {
            end.reverseParentPathsTo(fExpr);
            fExpr.addPathToChild(end);
        }
        LOGGER.exiting(CLASS_NAME, "computeFor");
    }

    private void computeSwitch(int firstIndex, int lastIndex) {
        LOGGER.entering(CLASS_NAME, "computeSwitch");
        int diff = lastIndex - firstIndex;
        boolean defaultStatement = false;
        DataFlowNode sStart = this.braceStack.get(firstIndex).getDataFlowNode();
        DataFlowNode sEnd = this.braceStack.get(lastIndex).getDataFlowNode();
        DataFlowNode end = sEnd.getChildren().get(0);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Stack(sStart)=>" + sStart + ",Stack(sEnd)=>" + sEnd + ",end=>" + end);
        }
        for (int i = 0; i < diff - 2; ++i) {
            StackObject so = this.braceStack.get(firstIndex + 2 + i);
            DataFlowNode node = so.getDataFlowNode();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("so(" + (firstIndex + 2 + i) + ")=>" + so + " has  dfn=>" + node + " with first child =>" + node.getChildren().get(0));
            }
            sStart.addPathToChild(node.getChildren().get(0));
            if (so.getType() != NodeType.SWITCH_LAST_DEFAULT_STATEMENT) continue;
            defaultStatement = true;
        }
        if (!defaultStatement) {
            sStart.addPathToChild(end);
        }
        LOGGER.exiting(CLASS_NAME, "computeSwitch");
    }

    private void computeWhile(int first, int last) {
        LOGGER.entering(CLASS_NAME, "computeWhile with first and last of" + first + "," + last);
        DataFlowNode wStart = this.braceStack.get(first).getDataFlowNode();
        DataFlowNode wEnd = this.braceStack.get(last).getDataFlowNode();
        DataFlowNode end = wEnd.getFlow().get(wEnd.getIndex() + 1);
        if (wStart.getIndex() != wEnd.getIndex()) {
            end.reverseParentPathsTo(wStart);
            wStart.addPathToChild(end);
        }
        LOGGER.exiting(CLASS_NAME, "computeWhile");
    }

    private void computeIf(int first, int second, int last) {
        LOGGER.entering(CLASS_NAME, "computeIf(3)", first + "," + second + "," + last);
        DataFlowNode ifStart = this.braceStack.get(first).getDataFlowNode();
        DataFlowNode ifEnd = this.braceStack.get(second).getDataFlowNode();
        DataFlowNode elseEnd = this.braceStack.get(last).getDataFlowNode();
        DataFlowNode elseStart = ifEnd.getFlow().get(ifEnd.getIndex() + 1);
        DataFlowNode end = elseEnd.getFlow().get(elseEnd.getIndex() + 1);
        LOGGER.log(Level.FINEST, "If ifstart={0}, ifEnd={1}, elseEnd={2}, elseStart={3}, end={4}", new Object[]{ifStart, ifEnd, elseEnd, elseStart, end});
        if (ifStart.getIndex() != ifEnd.getIndex() && ifEnd.getIndex() != elseEnd.getIndex()) {
            elseStart.reverseParentPathsTo(end);
            ifStart.addPathToChild(elseStart);
        } else if (ifStart.getIndex() == ifEnd.getIndex() && ifEnd.getIndex() != elseEnd.getIndex()) {
            ifStart.addPathToChild(end);
        } else if (ifEnd.getIndex() == elseEnd.getIndex() && ifStart.getIndex() != ifEnd.getIndex()) {
            ifStart.addPathToChild(end);
        }
        LOGGER.exiting(CLASS_NAME, "computeIf(3)");
    }

    private void computeIf(int first, int last) {
        LOGGER.entering(CLASS_NAME, "computeIf(2)");
        DataFlowNode ifStart = this.braceStack.get(first).getDataFlowNode();
        DataFlowNode ifEnd = this.braceStack.get(last).getDataFlowNode();
        if (ifStart.getIndex() != ifEnd.getIndex()) {
            DataFlowNode end = ifEnd.getFlow().get(ifEnd.getIndex() + 1);
            ifStart.addPathToChild(end);
        }
        LOGGER.exiting(CLASS_NAME, "computeIf(2)");
    }

    private static String dump(String description, List<StackObject> stackList) {
        StringBuilder stringDump = new StringBuilder("Stack List (");
        stringDump.append(description).append(") ListDump:\n");
        for (StackObject stackObject : stackList) {
            stringDump.append('\n').append(stackObject.toString());
        }
        return stringDump.toString();
    }
}

