/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.token.internal;

import net.sourceforge.pmd.cpd.token.TokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;

public abstract class BaseTokenFilter<T extends GenericToken>
implements TokenFilter {
    private final TokenManager tokenManager;
    private boolean discardingSuppressing;

    public BaseTokenFilter(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public final T getNextToken() {
        GenericToken currentToken = (GenericToken)this.tokenManager.getNextToken();
        while (!this.shouldStopProcessing(currentToken)) {
            this.analyzeToken(currentToken);
            this.processCPDSuppression(currentToken);
            if (!this.isDiscarding()) {
                return (T)currentToken;
            }
            currentToken = (GenericToken)this.tokenManager.getNextToken();
        }
        return null;
    }

    private boolean isDiscarding() {
        return this.discardingSuppressing || this.isLanguageSpecificDiscarding();
    }

    private void processCPDSuppression(T currentToken) {
        for (GenericToken comment = currentToken.getPreviousComment(); comment != null; comment = comment.getPreviousComment()) {
            if (comment.getImage().contains("CPD-OFF")) {
                this.discardingSuppressing = true;
                break;
            }
            if (!comment.getImage().contains("CPD-ON")) continue;
            this.discardingSuppressing = false;
            break;
        }
    }

    protected void analyzeToken(T currentToken) {
    }

    protected boolean isLanguageSpecificDiscarding() {
        return false;
    }

    protected abstract boolean shouldStopProcessing(T var1);
}

