/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class RuleSetFactoryCompatibility {
    private static final Logger LOG = Logger.getLogger(RuleSetFactoryCompatibility.class.getName());
    private List<RuleSetFilter> filters = new LinkedList<RuleSetFilter>();
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding=\"([^\"]+)\"");

    public RuleSetFactoryCompatibility() {
        this.addFilterRuleRenamed("java", "design", "UncommentedEmptyMethod", "UncommentedEmptyMethodBody");
        this.addFilterRuleRemoved("java", "controversial", "BooleanInversion");
        this.addFilterRuleRenamed("java", "design", "UseSingleton", "UseUtilityClass");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyCatchBlock");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyIfStatement");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyWhileStmt");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyTryBlock");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyFinallyBlock");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptySwitchStatements");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptySynchronizedBlock");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyStatementNotInLoop");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyInitializer");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyStatementBlock");
        this.addFilterRuleMoved("java", "basic", "empty", "EmptyStaticInitializer");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UnnecessaryConversionTemporary");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UnnecessaryReturn");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UnnecessaryFinalModifier");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UselessOverridingMethod");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UselessOperationOnImmutable");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UnusedNullCheckInEquals");
        this.addFilterRuleMoved("java", "basic", "unnecessary", "UselessParentheses");
        this.addFilterRuleRenamed("java", "design", "AvoidConstantsInterface", "ConstantsInInterface");
        this.addFilterRuleMovedAndRenamed("java", "unusedcode", "UnusedModifier", "unnecessary", "UnnecessaryModifier");
        this.addFilterRuleMoved("java", "controversial", "unnecessary", "UnnecessaryParentheses");
        this.addFilterRuleRenamed("java", "unnecessary", "UnnecessaryParentheses", "UselessParentheses");
        this.addFilterRuleMoved("java", "typeresolution", "coupling", "LooseCoupling");
        this.addFilterRuleMoved("java", "typeresolution", "clone", "CloneMethodMustImplementCloneable");
        this.addFilterRuleMoved("java", "typeresolution", "imports", "UnusedImports");
        this.addFilterRuleMoved("java", "typeresolution", "strictexception", "SignatureDeclareThrowsException");
        this.addFilterRuleRenamed("java", "naming", "MisleadingVariableName", "MIsLeadingVariableName");
        this.addFilterRuleRenamed("java", "unnecessary", "UnnecessaryFinalModifier", "UnnecessaryModifier");
        this.addFilterRuleRenamed("java", "empty", "EmptyStaticInitializer", "EmptyInitializer");
        this.addFilterRuleMovedAndRenamed("java", "logging-java", "GuardLogStatementJavaUtil", "logging-jakarta-commons", "GuardLogStatement");
        this.addFilterRuleRenamed("java", "logging-jakarta-commons", "GuardDebugLogging", "GuardLogStatement");
    }

    void addFilterRuleMovedAndRenamed(String language, String oldRuleset, String oldName, String newRuleset, String newName) {
        this.filters.add(RuleSetFilter.ruleMoved(language, oldRuleset, newRuleset, oldName));
        this.filters.add(RuleSetFilter.ruleRenamedMoved(language, newRuleset, oldName, newName));
    }

    void addFilterRuleRenamed(String language, String ruleset, String oldName, String newName) {
        this.filters.add(RuleSetFilter.ruleRenamed(language, ruleset, oldName, newName));
    }

    void addFilterRuleMoved(String language, String oldRuleset, String newRuleset, String ruleName) {
        this.filters.add(RuleSetFilter.ruleMoved(language, oldRuleset, newRuleset, ruleName));
    }

    void addFilterRuleRemoved(String language, String ruleset, String name) {
        this.filters.add(RuleSetFilter.ruleRemoved(language, ruleset, name));
    }

    public Reader filterRuleSetFile(InputStream stream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        String encoding = this.determineEncoding(bytes);
        String ruleset = new String(bytes, encoding);
        ruleset = this.applyAllFilters(ruleset);
        return new StringReader(ruleset);
    }

    private String applyAllFilters(String ruleset) {
        String result = ruleset;
        for (RuleSetFilter filter : this.filters) {
            result = filter.apply(result);
        }
        return result;
    }

    String determineEncoding(byte[] bytes) {
        String firstBytes = new String(bytes, 0, bytes.length > 1024 ? 1024 : bytes.length, Charset.forName("ISO-8859-1"));
        Matcher matcher = ENCODING_PATTERN.matcher(firstBytes);
        String encoding = Charset.forName("UTF-8").name();
        if (matcher.find()) {
            encoding = matcher.group(1);
        }
        return encoding;
    }

    private static class RuleSetFilter {
        private final Pattern refPattern;
        private final String replacement;
        private Pattern exclusionPattern;
        private String exclusionReplacement;
        private final String logMessage;

        private RuleSetFilter(String refPattern, String replacement, String logMessage) {
            this.logMessage = logMessage;
            if (replacement != null) {
                this.refPattern = Pattern.compile("ref=\"" + Pattern.quote(refPattern) + "\"");
                this.replacement = "ref=\"" + replacement + "\"";
            } else {
                this.refPattern = Pattern.compile("<rule\\s+ref=\"" + Pattern.quote(refPattern) + "\"\\s*/>");
                this.replacement = "";
            }
        }

        private void setExclusionPattern(String oldName, String newName) {
            this.exclusionPattern = Pattern.compile("<exclude\\s+name=[\"']" + Pattern.quote(oldName) + "[\"']\\s*/>");
            this.exclusionReplacement = newName != null ? "<exclude name=\"" + newName + "\" />" : "";
        }

        public static RuleSetFilter ruleRenamed(String language, String ruleset, String oldName, String newName) {
            RuleSetFilter filter = RuleSetFilter.ruleRenamedMoved(language, ruleset, oldName, newName);
            filter.setExclusionPattern(oldName, newName);
            return filter;
        }

        public static RuleSetFilter ruleRenamedMoved(String language, String ruleset, String oldName, String newName) {
            String base = "rulesets/" + language + "/" + ruleset + ".xml/";
            return new RuleSetFilter(base + oldName, base + newName, "The rule \"" + oldName + "\" has been renamed to \"" + newName + "\". Please change your ruleset!");
        }

        public static RuleSetFilter ruleMoved(String language, String oldRuleset, String newRuleset, String ruleName) {
            String base = "rulesets/" + language + "/";
            return new RuleSetFilter(base + oldRuleset + ".xml/" + ruleName, base + newRuleset + ".xml/" + ruleName, "The rule \"" + ruleName + "\" has been moved from ruleset \"" + oldRuleset + "\" to \"" + newRuleset + "\". Please change your ruleset!");
        }

        public static RuleSetFilter ruleRemoved(String language, String ruleset, String name) {
            RuleSetFilter filter = new RuleSetFilter("rulesets/" + language + "/" + ruleset + ".xml/" + name, null, "The rule \"" + name + "\" in ruleset \"" + ruleset + "\" has been removed from PMD and no longer exists. Please change your ruleset!");
            filter.setExclusionPattern(name, null);
            return filter;
        }

        String apply(String ruleset) {
            String result = ruleset;
            Matcher matcher = this.refPattern.matcher(ruleset);
            if (matcher.find()) {
                result = matcher.replaceAll(this.replacement);
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Applying rule set filter: " + this.logMessage);
                }
            }
            if (this.exclusionPattern == null) {
                return result;
            }
            Matcher exclusions = this.exclusionPattern.matcher(result);
            if (exclusions.find()) {
                result = exclusions.replaceAll(this.exclusionReplacement);
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Applying rule set filter for exclusions: " + this.logMessage);
                }
            }
            return result;
        }
    }
}

