/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.filter;

import java.io.File;
import java.util.Locale;
import net.sourceforge.pmd.util.filter.Filter;

public class FileExtensionFilter
implements Filter<File> {
    protected final String[] extensions;
    protected final boolean ignoreCase;

    public FileExtensionFilter(String ... extensions) {
        this(true, extensions);
    }

    public FileExtensionFilter(boolean ignoreCase, String ... extensions) {
        this.extensions = extensions;
        this.ignoreCase = ignoreCase;
        if (ignoreCase) {
            for (int i = 0; i < this.extensions.length; ++i) {
                this.extensions[i] = this.extensions[i].toUpperCase(Locale.ROOT);
            }
        }
    }

    @Override
    public boolean filter(File file) {
        boolean accept;
        boolean bl = accept = this.extensions == null;
        if (!accept) {
            for (String extension : this.extensions) {
                String name = file.getName();
                if (!(this.ignoreCase ? name.toUpperCase(Locale.ROOT).endsWith(extension) : name.endsWith(extension))) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }
}

