/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.properties.AbstractProperty;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptorField;
import org.apache.commons.lang3.StringUtils;

@Deprecated
abstract class AbstractMultiValueProperty<V>
extends AbstractProperty<List<V>>
implements MultiValuePropertyDescriptor<V> {
    private final List<V> defaultValue;
    private final char multiValueDelimiter;

    AbstractMultiValueProperty(String theName, String theDescription, List<V> theDefault, float theUIOrder, boolean isDefinedExternally) {
        this(theName, theDescription, theDefault, theUIOrder, '|', isDefinedExternally);
    }

    AbstractMultiValueProperty(String theName, String theDescription, List<V> theDefault, float theUIOrder, char delimiter, boolean isDefinedExternally) {
        super(theName, theDescription, theUIOrder, isDefinedExternally);
        this.defaultValue = Collections.unmodifiableList(theDefault);
        this.multiValueDelimiter = delimiter;
    }

    @Override
    public final boolean isMultiValue() {
        return true;
    }

    @Override
    public String propertyErrorFor(Rule rule) {
        List realValues = (List)rule.getProperty(this);
        return realValues == null ? null : this.errorFor(realValues);
    }

    @Override
    public String errorFor(List<V> values) {
        for (V value2 : values) {
            String err = this.valueErrorFor(value2);
            if (err == null) continue;
            return err;
        }
        return null;
    }

    protected String valueErrorFor(V value) {
        return value != null || this.defaultHasNullValue() ? null : "missing value";
    }

    private boolean defaultHasNullValue() {
        return this.defaultValue == null || this.defaultValue.contains(null);
    }

    @Override
    protected String defaultAsString() {
        return this.asDelimitedString((List<V>)this.defaultValue(), this.multiValueDelimiter());
    }

    private String asDelimitedString(List<V> values, char delimiter) {
        if (values == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (V value : values) {
            sb.append(this.asString(value)).append(delimiter);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public List<V> defaultValue() {
        return this.defaultValue;
    }

    @Override
    public char multiValueDelimiter() {
        return this.multiValueDelimiter;
    }

    protected String asString(V value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public final String asDelimitedString(List<V> values) {
        return this.asDelimitedString(values, this.multiValueDelimiter());
    }

    @Override
    public List<V> valueFrom(String valueString) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return Collections.emptyList();
        }
        String[] strValues = valueString.split(Pattern.quote("" + this.multiValueDelimiter()));
        ArrayList<V> values = new ArrayList<V>(strValues.length);
        for (String strValue : strValues) {
            values.add(this.createFrom(strValue));
        }
        return values;
    }

    protected abstract V createFrom(String var1);

    @Override
    protected void addAttributesTo(Map<PropertyDescriptorField, String> attributes) {
        super.addAttributesTo(attributes);
        attributes.put(PropertyDescriptorField.DELIMITER, Character.toString(this.multiValueDelimiter()));
    }
}

