/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.Objects;
import net.sourceforge.pmd.lang.ast.QualifiableNode;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricMemoizer;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsComputer;
import net.sourceforge.pmd.lang.metrics.ProjectMemoizer;
import net.sourceforge.pmd.lang.metrics.ResultOption;

public abstract class AbstractMetricsFacade<T extends QualifiableNode, O extends QualifiableNode> {
    private static final String NULL_KEY_MESSAGE = "The metric key must not be null";
    private static final String NULL_OPTIONS_MESSAGE = "The metric options must not be null";
    private static final String NULL_NODE_MESSAGE = "The node must not be null";

    protected abstract MetricsComputer<T, O> getLanguageSpecificComputer();

    protected abstract ProjectMemoizer<T, O> getLanguageSpecificProjectMemoizer();

    public double computeForType(MetricKey<T> key, T node, MetricOptions options) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(node, NULL_NODE_MESSAGE);
        if (!key.supports(node)) {
            return Double.NaN;
        }
        MetricMemoizer<T> memoizer = this.getLanguageSpecificProjectMemoizer().getClassMemoizer(node.getQualifiedName());
        return memoizer == null ? Double.NaN : this.getLanguageSpecificComputer().computeForType(key, node, false, options, memoizer);
    }

    public double computeForOperation(MetricKey<O> key, O node, MetricOptions options) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(node, NULL_NODE_MESSAGE);
        if (!key.supports(node)) {
            return Double.NaN;
        }
        MetricMemoizer<O> memoizer = this.getLanguageSpecificProjectMemoizer().getOperationMemoizer(node.getQualifiedName());
        return memoizer == null ? Double.NaN : this.getLanguageSpecificComputer().computeForOperation(key, node, false, options, memoizer);
    }

    public double computeWithResultOption(MetricKey<O> key, T node, MetricOptions options, ResultOption resultOption) {
        Objects.requireNonNull(key, NULL_KEY_MESSAGE);
        Objects.requireNonNull(options, NULL_OPTIONS_MESSAGE);
        Objects.requireNonNull(node, NULL_NODE_MESSAGE);
        Objects.requireNonNull(resultOption, "The result option must not be null");
        return this.getLanguageSpecificComputer().computeWithResultOption(key, node, false, options, resultOption, this.getLanguageSpecificProjectMemoizer());
    }
}

