/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.PMDTask;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import net.sourceforge.pmd.util.log.AntLogHandler;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class PMDTaskImpl {
    private Path classpath;
    private Path auxClasspath;
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final PMDConfiguration configuration = new PMDConfiguration();
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private int maxRuleViolations = 0;
    private String failuresPropertyName;
    private Project project;

    public PMDTaskImpl(PMDTask task) {
        this.configuration.setReportShortNames(task.isShortFilenames());
        this.configuration.setSuppressMarker(task.getSuppressMarker());
        this.failOnError = task.isFailOnError();
        this.failOnRuleViolation = task.isFailOnRuleViolation();
        this.maxRuleViolations = task.getMaxRuleViolations();
        if (this.maxRuleViolations > 0) {
            this.failOnRuleViolation = true;
        }
        this.configuration.setRuleSets(task.getRulesetFiles());
        this.configuration.setRuleSetFactoryCompatibilityEnabled(!task.isNoRuleSetCompatibility());
        if (task.getEncoding() != null) {
            this.configuration.setSourceEncoding(task.getEncoding());
        }
        this.configuration.setThreads(task.getThreads());
        this.failuresPropertyName = task.getFailuresPropertyName();
        this.configuration.setMinimumPriority(RulePriority.valueOf(task.getMinimumPriority()));
        this.configuration.setAnalysisCacheLocation(task.getCacheLocation());
        this.configuration.setIgnoreIncrementalAnalysis(task.isNoCache());
        SourceLanguage version = task.getSourceLanguage();
        if (version != null) {
            LanguageVersion languageVersion = LanguageRegistry.findLanguageVersionByTerseName(version.getName() + ' ' + version.getVersion());
            if (languageVersion == null) {
                throw new BuildException("The following language is not supported:" + version + '.');
            }
            this.configuration.setDefaultLanguageVersion(languageVersion);
        }
        this.classpath = task.getClasspath();
        this.auxClasspath = task.getAuxClasspath();
        this.filesets.addAll(task.getFilesets());
        this.formatters.addAll(task.getFormatters());
        this.project = task.getProject();
    }

    private void doTask() {
        this.setupClassLoader();
        ResourceLoader rl = this.setupResourceLoader();
        RuleSetFactory ruleSetFactory = RulesetsFactoryUtils.getRulesetFactory(this.configuration, rl);
        try {
            String ruleSets = this.configuration.getRuleSets();
            if (StringUtils.isNotBlank((CharSequence)ruleSets)) {
                this.configuration.setRuleSets(this.project.replaceProperties(ruleSets));
            }
            RuleSets rules = ruleSetFactory.createRuleSets(this.configuration.getRuleSets());
            this.logRulesUsed(rules);
        }
        catch (RuleSetNotFoundException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        if (this.configuration.getSuppressMarker() != null) {
            this.project.log("Setting suppress marker to be " + this.configuration.getSuppressMarker(), 3);
        }
        for (Formatter formatter : this.formatters) {
            this.project.log("Sending a report to " + formatter, 3);
            formatter.start(this.project.getBaseDir().toString());
        }
        RuleContext ctx = new RuleContext();
        Report errorReport = new Report();
        final AtomicInteger reportSize = new AtomicInteger();
        String separator = System.getProperty("file.separator");
        for (FileSet fs : this.filesets) {
            String[] srcFiles;
            LinkedList<DataSource> files = new LinkedList<DataSource>();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            for (String string : srcFiles = ds.getIncludedFiles()) {
                File file = new File(ds.getBasedir() + separator + string);
                files.add(new FileDataSource(file));
            }
            final String inputPaths = ds.getBasedir().getPath();
            this.configuration.setInputPaths(inputPaths);
            AbstractRenderer logRenderer = new AbstractRenderer("log", "Logging renderer"){

                @Override
                public void start() {
                }

                @Override
                public void startFileAnalysis(DataSource dataSource) {
                    PMDTaskImpl.this.project.log("Processing file " + dataSource.getNiceFileName(false, inputPaths), 3);
                }

                @Override
                public void renderFileReport(Report r) {
                    int size = r.size();
                    if (size > 0) {
                        reportSize.addAndGet(size);
                    }
                }

                @Override
                public void end() {
                }

                @Override
                public String defaultFileExtension() {
                    return null;
                }
            };
            ArrayList<Renderer> renderers = new ArrayList<Renderer>(this.formatters.size() + 1);
            renderers.add(logRenderer);
            for (Formatter formatter : this.formatters) {
                renderers.add(formatter.getRenderer());
            }
            try {
                PMD.processFiles(this.configuration, ruleSetFactory, files, ctx, renderers);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(ctx, errorReport, runtimeException);
            }
        }
        int problemCount = reportSize.get();
        this.project.log(problemCount + " problems found", 3);
        for (Formatter formatter : this.formatters) {
            formatter.end(errorReport);
        }
        if (this.failuresPropertyName != null && problemCount > 0) {
            this.project.setProperty(this.failuresPropertyName, String.valueOf(problemCount));
            this.project.log("Setting property " + this.failuresPropertyName + " to " + problemCount, 3);
        }
        if (this.failOnRuleViolation && problemCount > this.maxRuleViolations) {
            throw new BuildException("Stopping build since PMD found " + problemCount + " rule violations in the code");
        }
    }

    private ResourceLoader setupResourceLoader() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        this.classpath.add(new Path(null, this.project.getBaseDir().toString()));
        this.project.log("Using the AntClassLoader: " + this.classpath, 3);
        boolean parentFirst = true;
        return new ResourceLoader((ClassLoader)new AntClassLoader(Thread.currentThread().getContextClassLoader(), this.project, this.classpath, true));
    }

    private void handleError(RuleContext ctx, Report errorReport, RuntimeException pmde) {
        pmde.printStackTrace();
        this.project.log(pmde.toString(), 3);
        Throwable cause = pmde.getCause();
        if (cause != null) {
            try (StringWriter strWriter = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(strWriter);){
                cause.printStackTrace(printWriter);
                this.project.log(strWriter.toString(), 3);
            }
            catch (IOException e) {
                this.project.log("Error while closing stream", (Throwable)e, 0);
            }
            if (StringUtils.isNotBlank((CharSequence)cause.getMessage())) {
                this.project.log(cause.getMessage(), 3);
            }
        }
        if (this.failOnError) {
            throw new BuildException((Throwable)pmde);
        }
        errorReport.addError(new Report.ProcessingError(pmde, ctx.getSourceCodeFilename()));
    }

    private void setupClassLoader() {
        try {
            if (this.auxClasspath != null) {
                this.project.log("Using auxclasspath: " + this.auxClasspath, 3);
                this.configuration.prependClasspath(this.auxClasspath.toString());
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void execute() throws BuildException {
        AntLogHandler antLogHandler = new AntLogHandler(this.project);
        ScopedLogHandlersManager logManager = new ScopedLogHandlersManager(antLogHandler.getAntLogLevel(), antLogHandler);
        try {
            this.doTask();
        }
        finally {
            logManager.close();
            if (this.configuration.getClassLoader() instanceof ClasspathClassLoader) {
                IOUtil.tryCloseClassLoader(this.configuration.getClassLoader());
            }
        }
    }

    private void logRulesUsed(RuleSets rules) {
        RuleSet[] ruleSets;
        this.project.log("Using these rulesets: " + this.configuration.getRuleSets(), 3);
        for (RuleSet ruleSet : ruleSets = rules.getAllRuleSets()) {
            for (Rule rule : ruleSet.getRules()) {
                this.project.log("Using rule " + rule.getName(), 3);
            }
        }
    }
}

