/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.saxon.DocumentNode;
import net.sourceforge.pmd.lang.ast.xpath.saxon.ElementNode;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.lang.rule.xpath.AbstractXPathRuleQuery;
import net.sourceforge.pmd.lang.xpath.Initializer;

public class SaxonXPathRuleQuery
extends AbstractXPathRuleQuery {
    private XPathExpression xpathExpression;
    private List<XPathVariable> xpathVariables;
    private static final int MAX_CACHE_SIZE = 20;
    private static final Map<Node, DocumentNode> CACHE = new LinkedHashMap<Node, DocumentNode>(20){
        private static final long serialVersionUID = -7653916493967142443L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Node, DocumentNode> eldest) {
            return this.size() > 20;
        }
    };

    @Override
    public boolean isSupportedVersion(String version) {
        return "1.0 compatibility".equals(version) || "2.0".equals(version);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Node> evaluate(Node node, RuleContext data) {
        this.initializeXPathExpression();
        ArrayList<Node> results = new ArrayList<Node>();
        try {
            DocumentNode documentNode = this.getDocumentNode(node);
            ElementNode rootElementNode = documentNode.nodeToElementNode.get(node);
            XPathDynamicContext xpathDynamicContext = this.xpathExpression.createDynamicContext((Item)rootElementNode);
            for (XPathVariable xpathVariable : this.xpathVariables) {
                String name = xpathVariable.getVariableQName().getLocalName();
                for (Map.Entry<PropertyDescriptor<?>, Object> entry : this.properties.entrySet()) {
                    StringValue valueRepresentation;
                    void var12_13;
                    if (!name.equals(entry.getKey().name())) continue;
                    PropertyDescriptor<?> propertyDescriptor = entry.getKey();
                    if (propertyDescriptor instanceof PropertyDescriptorWrapper) {
                        PropertyDescriptor propertyDescriptor2 = ((PropertyDescriptorWrapper)propertyDescriptor).getPropertyDescriptor();
                    }
                    Object value = entry.getValue();
                    if (var12_13 instanceof StringProperty) {
                        valueRepresentation = new StringValue((CharSequence)((String)value));
                    } else if (var12_13 instanceof BooleanProperty) {
                        valueRepresentation = BooleanValue.get((boolean)((Boolean)value));
                    } else if (var12_13 instanceof IntegerProperty) {
                        valueRepresentation = Int64Value.makeIntegerValue((long)((Integer)value).intValue());
                    } else {
                        if (!(var12_13 instanceof EnumeratedProperty)) throw new RuntimeException("Unable to create ValueRepresentaton for PropertyDescriptor: " + var12_13);
                        if (!(value instanceof String)) throw new RuntimeException("Unable to create ValueRepresentaton for non-String EnumeratedProperty value: " + value);
                        valueRepresentation = new StringValue((CharSequence)((String)value));
                    }
                    xpathDynamicContext.setVariable(xpathVariable, (ValueRepresentation)valueRepresentation);
                }
            }
            List nodes = this.xpathExpression.evaluate(xpathDynamicContext);
            for (ElementNode elementNode : nodes) {
                results.add((Node)elementNode.getUnderlyingNode());
            }
            return results;
        }
        catch (XPathException e) {
            throw new RuntimeException(this.xpath + " had problem: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentNode getDocumentNode(Node node) {
        DocumentNode documentNode;
        Node root = node;
        while (root.jjtGetParent() != null) {
            root = root.jjtGetParent();
        }
        Map<Node, DocumentNode> map = CACHE;
        synchronized (map) {
            documentNode = CACHE.get(root);
            if (documentNode == null) {
                documentNode = new DocumentNode(root);
                CACHE.put(root, documentNode);
            }
        }
        return documentNode;
    }

    private void initializeXPathExpression() {
        if (this.xpathExpression != null) {
            return;
        }
        try {
            XPathEvaluator xpathEvaluator = new XPathEvaluator();
            XPathStaticContext xpathStaticContext = xpathEvaluator.getStaticContext();
            if ("1.0 compatibility".equals(this.version)) {
                ((AbstractStaticContext)xpathStaticContext).setBackwardsCompatibilityMode(true);
            }
            Initializer.initialize((IndependentContext)xpathStaticContext);
            this.xpathVariables = new ArrayList<XPathVariable>();
            for (PropertyDescriptor<?> propertyDescriptor : this.properties.keySet()) {
                String name = propertyDescriptor.name();
                if ("xpath".equals(name)) continue;
                XPathVariable xpathVariable = xpathStaticContext.declareVariable(null, name);
                this.xpathVariables.add(xpathVariable);
            }
            this.xpathExpression = xpathEvaluator.createExpression(this.xpath);
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }
}

